/*
 * Copyright (C) 2020 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.services.eipbp.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for creating a newly eipBp.
 */
public class CreateEipBpRequest extends AbstractBceRequest {
    /**
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/EIP/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    /**
     * The name of eipbp. The optional parameter.
     */
    private String name;
    /**
     * The eip address that the eipbp attach. Param "eip" and "eipGroupId" will has only one param take effect.
     */
    private String eip;
    /**
     * The eipgroupId that the eipbp attach. Param "eip" and "eipGroupId" will has only one param take effect.
     */
    private String eipGroupId;
    /**
     * The bandwidth of eipbp in Mbps.
     */
    private Integer bandwidthInMbps;
    /**
     * The eipbp autoReleaseTime. Format is "yyyy-MM-ddTHH:mm:ssZ". The optional parameter.
     */
    private String autoReleaseTime;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getBandwidthInMbps() {
        return bandwidthInMbps;
    }

    public void setBandwidthInMbps(Integer bandwidthInMbps) {
        this.bandwidthInMbps = bandwidthInMbps;
    }

    public String getEip() {
        return eip;
    }

    public void setEip(String eip) {
        this.eip = eip;
    }

    public String getEipGroupId() {
        return eipGroupId;
    }

    public void setEipGroupId(String eipGroupId) {
        this.eipGroupId = eipGroupId;
    }

    public String getAutoReleaseTime() {
        return autoReleaseTime;
    }

    public void setAutoReleaseTime(String autoReleaseTime) {
        this.autoReleaseTime = autoReleaseTime;
    }

    public CreateEipBpRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public CreateEipBpRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CreateEipBpRequest withEip(String eip) {
        this.eip = eip;
        return this;
    }

    public CreateEipBpRequest withEipGroupId(String eipGroupId) {
        this.eipGroupId = eipGroupId;
        return this;
    }

    public CreateEipBpRequest withBandwidthInMbps(Integer bandwidthInMbps) {
        this.bandwidthInMbps = bandwidthInMbps;
        return this;
    }


    public CreateEipBpRequest withAutoReleaseTime(String autoReleaseTime) {
        this.autoReleaseTime = autoReleaseTime;
        return this;
    }

    public CreateEipBpRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
