/*
 * Copyright (c) 2019 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.blb.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.List;

/**
 * The request for appBlb serverGroup port.
 */
public class AppSgPortRequest extends AbstractBceRequest {

    /**
     * the short id of the blb.
     */
    private String blbId;
    /**
     * the short id of the AppServerGroup.
     */
    private String sgId;
    /**
     * the short id of AppServerGroupPort.
     */
    private String portId;
    /**
     * the port of AppServerGroup.
     */
    private Integer port;
    /**
     * the type of port.
     */
    private String type;
    /**
     * the protocol of health check.
     */
    private String healthCheck;
    /**
     * the port of health check.
     */
    private Integer healthCheckPort;
    /**
     * the uri of health check.
     */
    private String healthCheckUrlPath;
    /**
     * the timeout (in second) of health check.
     */
    private Integer healthCheckTimeoutInSecond;
    /**
     * the interval (in second) of health check.
     */
    private Integer healthCheckIntervalInSecond;
    /**
     * down retry times of health check.
     */
    private Integer healthCheckDownRetry;
    /**
     * up retry times of health check.
     */
    private Integer healthCheckUpRetry;
    /**
     * the normal status of health check.
     */
    private String healthCheckNormalStatus;
    /**
     * the string of udp health check.
     */
    private String udpHealthCheckString;

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    /**
     * the short id of appServerGroupPort list.
     */
    private List<String> portIdList;


    public List<String> getPortIdList() {
        return portIdList;
    }

    public void setPortIdList(List<String> portIdList) {
        this.portIdList = portIdList;
    }

    public AppSgPortRequest withBlbId(String blbId) {
        this.blbId = blbId;
        return this;
    }

    public AppSgPortRequest withSgId(String sgId) {
        this.sgId = sgId;
        return this;
    }

    public AppSgPortRequest withPort(Integer port) {
        this.port = port;
        return this;
    }
    public AppSgPortRequest withPortIdList(List<String> portIdList) {
        this.portIdList = portIdList;
        return this;
    }

    public AppSgPortRequest withType(String type) {
        this.type = type;
        return this;
    }

    public String getSgId() {
        return sgId;
    }

    public void setSgId(String sgId) {
        this.sgId = sgId;
    }



    public String getBlbId() {
        return blbId;
    }

    public void setBlbId(String blbId) {
        this.blbId = blbId;
    }


    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHealthCheck() {
        return healthCheck;
    }

    public void setHealthCheck(String healthCheck) {
        this.healthCheck = healthCheck;
    }

    public Integer getHealthCheckPort() {
        return healthCheckPort;
    }

    public void setHealthCheckPort(Integer healthCheckPort) {
        this.healthCheckPort = healthCheckPort;
    }

    public String getHealthCheckUrlPath() {
        return healthCheckUrlPath;
    }

    public void setHealthCheckUrlPath(String healthCheckUrlPath) {
        this.healthCheckUrlPath = healthCheckUrlPath;
    }

    public Integer getHealthCheckTimeoutInSecond() {
        return healthCheckTimeoutInSecond;
    }

    public void setHealthCheckTimeoutInSecond(Integer healthCheckTimeoutInSecond) {
        this.healthCheckTimeoutInSecond = healthCheckTimeoutInSecond;
    }

    public Integer getHealthCheckIntervalInSecond() {
        return healthCheckIntervalInSecond;
    }

    public void setHealthCheckIntervalInSecond(Integer healthCheckIntervalInSecond) {
        this.healthCheckIntervalInSecond = healthCheckIntervalInSecond;
    }

    public Integer getHealthCheckDownRetry() {
        return healthCheckDownRetry;
    }

    public void setHealthCheckDownRetry(Integer healthCheckDownRetry) {
        this.healthCheckDownRetry = healthCheckDownRetry;
    }

    public Integer getHealthCheckUpRetry() {
        return healthCheckUpRetry;
    }

    public void setHealthCheckUpRetry(Integer healthCheckUpRetry) {
        this.healthCheckUpRetry = healthCheckUpRetry;
    }

    public String getHealthCheckNormalStatus() {
        return healthCheckNormalStatus;
    }

    public void setHealthCheckNormalStatus(String healthCheckNormalStatus) {
        this.healthCheckNormalStatus = healthCheckNormalStatus;
    }

    public String getUdpHealthCheckString() {
        return udpHealthCheckString;
    }

    public void setUdpHealthCheckString(String udpHealthCheckString) {
        this.udpHealthCheckString = udpHealthCheckString;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getPortId() {
        return portId;
    }

    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Override
    public AppSgPortRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
