/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vodpro;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.vodpro.model.adaptor.RequestType;
import com.baidubce.services.vodpro.model.adaptor.request.QueryVcaRequest;
import com.baidubce.services.vodpro.model.adaptor.request.QueryVcrRequest;
import com.baidubce.services.vodpro.model.adaptor.request.TaskStartRequest;
import com.baidubce.services.vodpro.model.adaptor.response.QueryVcaResponse;
import com.baidubce.services.vodpro.model.adaptor.response.QueryVcrResponse;
import com.baidubce.services.vodpro.model.adaptor.response.TaskStartResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class AdaptorClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PATH_TASK = "task";
    private static HttpResponseHandler[] vodProAdaptorHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public AdaptorClient() {
        this(new BceClientConfiguration());
    }

    public AdaptorClient(BceClientConfiguration config) {
        super(config, vodProAdaptorHandlers);
    }

    public TaskStartResponse startTask(RequestType type, String url, String description, String preset) {
        TaskStartRequest request = new TaskStartRequest();
        request.setType(type);
        request.setDescription(description);
        request.setPreset(preset);
        request.setUrl(url);
        return this.startTask(request);
    }

    private TaskStartResponse startTask(TaskStartRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, VERSION, PATH_TASK);
        internalRequest.addParameter("type", request.getType().toString());
        return this.invokeHttpClient(internalRequest, TaskStartResponse.class);
    }

    public QueryVcaResponse queryAdaptorVca(String url) {
        QueryVcaRequest request = new QueryVcaRequest();
        request.setUrl(url);
        return this.queryAdaptorVca(request);
    }

    private QueryVcaResponse queryAdaptorVca(QueryVcaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, PATH_TASK);
        internalRequest.addParameter("vca", null);
        internalRequest.addParameter("url", request.getUrl());
        return this.invokeHttpClient(internalRequest, QueryVcaResponse.class);
    }

    public QueryVcrResponse queryAdaptorVcr(String url) {
        QueryVcrRequest request = new QueryVcrRequest();
        request.setUrl(url);
        return this.queryAdaptorVcr(request);
    }

    private QueryVcrResponse queryAdaptorVcr(QueryVcrRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, PATH_TASK);
        internalRequest.addParameter("vcr", null);
        internalRequest.addParameter("url", request.getUrl());
        return this.invokeHttpClient(internalRequest, QueryVcrResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = this.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }

    public URI appendUri(URI baseUri, String ... pathComponents) {
        StringBuilder builder = new StringBuilder(baseUri.toASCIIString());
        for (String path : pathComponents) {
            if (path == null || path.length() <= 0) continue;
            if ((path = HttpUtils.normalize(path).replace("%2F", "/").replace("%3F", "?")).startsWith("/")) {
                if (builder.charAt(builder.length() - 1) == '/') {
                    builder.setLength(builder.length() - 1);
                }
            } else if (builder.charAt(builder.length() - 1) != '/') {
                builder.append('/');
            }
            builder.append(path);
        }
        try {
            return new URI(builder.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }
}

