/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestoragehbaseclient.hbase;

import com.baidubce.services.tablestoragehbaseclient.adaptor.TableStorageAdaptor;
import com.baidubce.services.tablestoragehbaseclient.adaptor.TablestorageConfiguration;
import com.baidubce.services.tablestoragehbaseclient.hbase.TablestorageConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;

public class TablestorageBufferedMutator
implements BufferedMutator {
    private final TableName tableName;
    private TablestorageConnection connection;
    private TableStorageAdaptor adaptor;
    private volatile long writeBufferSize;
    private AtomicLong currentWriteBufferSize;
    private final ConcurrentLinkedQueue<Mutation> writeBuffer;
    private boolean closed;

    public TablestorageBufferedMutator(TablestorageConnection connection, TableName tableName) {
        this.tableName = tableName;
        this.connection = connection;
        TablestorageConfiguration conf = connection.getTablestorageConfiguration();
        this.adaptor = new TableStorageAdaptor(conf.getEndpoint(), conf.getInstanceName(), conf.getAccessKeyId(), conf.getSecretAccessKey());
        this.writeBuffer = new ConcurrentLinkedQueue();
        this.currentWriteBufferSize = new AtomicLong(0L);
        this.writeBufferSize = this.connection.getConfiguration().getLong("hbase.client.write.buffer", 0x200000L);
        this.closed = false;
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }

    public void mutate(Mutation mutation) throws IOException {
        this.mutate(Collections.singletonList(mutation));
    }

    public void mutate(List<? extends Mutation> mutations) throws IOException {
        if (this.closed) {
            throw new IOException("TableStorageBufferedMutator has been closed.");
        }
        for (Mutation mutation : mutations) {
            this.writeBuffer.add(mutation);
            this.currentWriteBufferSize.getAndAdd(mutation.heapSize());
        }
        if (this.currentWriteBufferSize.get() >= this.writeBufferSize) {
            this.flush();
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flush();
        this.adaptor.close();
    }

    public void flush() throws IOException {
        Mutation mutation;
        ArrayList<Put> batchPuts = new ArrayList<Put>();
        ArrayList<Delete> batchDelets = new ArrayList<Delete>();
        while ((mutation = this.writeBuffer.poll()) != null) {
            if (mutation instanceof Put) {
                batchPuts.add((Put)mutation);
                continue;
            }
            if (!(mutation instanceof Delete)) continue;
            batchDelets.add((Delete)mutation);
        }
        if (batchPuts.size() != 0) {
            this.adaptor.batchPutRow(this.tableName.getNameAsString(), batchPuts);
        }
        if (batchDelets.size() != 0) {
            this.adaptor.batchDeleteRow(this.tableName.getNameAsString(), batchDelets);
        }
        this.currentWriteBufferSize.set(0L);
    }

    public long getWriteBufferSize() {
        return this.currentWriteBufferSize.get();
    }
}

