/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.peerconn;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.peerconn.PeerConnClientConfiguration;
import com.baidubce.services.peerconn.model.CreatePeerConnRequest;
import com.baidubce.services.peerconn.model.CreatePeerConnResponse;
import com.baidubce.services.peerconn.model.GetPeerConnRequest;
import com.baidubce.services.peerconn.model.GetPeerConnResponse;
import com.baidubce.services.peerconn.model.ListPeerConnRequest;
import com.baidubce.services.peerconn.model.ListPeerConnResponse;
import com.baidubce.services.peerconn.model.ModifyBandwidthRequest;
import com.baidubce.services.peerconn.model.ModifyPeerConnRequest;
import com.baidubce.services.peerconn.model.PeerConnIdRequest;
import com.baidubce.services.peerconn.model.PurchaseReservedPeerConnRequest;
import com.baidubce.services.peerconn.model.SyncDnsRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerConnClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerConnClient.class);
    private static final String VERSION = "v1";
    private static final String PREFIX = "peerconn";
    private static final HttpResponseHandler[] peerConnHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public PeerConnClient() {
        this(new PeerConnClientConfiguration());
    }

    public PeerConnClient(PeerConnClientConfiguration clientConfiguration) {
        super(clientConfiguration, peerConnHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreatePeerConnResponse createPeerConn(CreatePeerConnRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getPeerRegion(), "PeerRegion should not be empty");
        Validate.checkStringNotEmpty(request.getPeerVpcId(), "PeerVpcId should not be empty");
        Validate.checkStringNotEmpty(request.getLocalVpcId(), "LocalVpcId should not be empty");
        Preconditions.checkNotNull((Object)request.getBilling(), (Object)"billing should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreatePeerConnResponse.class);
    }

    public ListPeerConnResponse listPeerConn(ListPeerConnRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getVpcId(), "vpcId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PREFIX);
        if (StringUtils.isNotBlank((CharSequence)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        internalRequest.addParameter("vpcId", request.getVpcId());
        return this.invokeHttpClient(internalRequest, ListPeerConnResponse.class);
    }

    public GetPeerConnResponse getPeerConn(GetPeerConnRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getPeerConnId(), "PeerConnId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PREFIX, request.getPeerConnId());
        return this.invokeHttpClient(internalRequest, GetPeerConnResponse.class);
    }

    public void modifyPeerConn(ModifyPeerConnRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getPeerConnId());
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void accept(PeerConnIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getPeerConnId());
        internalRequest.addParameter("accept", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void reject(PeerConnIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getPeerConnId());
        internalRequest.addParameter("reject", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void release(PeerConnIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, PREFIX, request.getPeerConnId());
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyBandwith(ModifyBandwidthRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getPeerConnId());
        internalRequest.addParameter("resize", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void purchaseReserved(PurchaseReservedPeerConnRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getPeerConnId());
        internalRequest.addParameter("purchaseReserved", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void openSyncDns(SyncDnsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getPeerConnId());
        internalRequest.addParameter("open", null);
        internalRequest.addParameter("role", request.getRole());
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void closeSyncDns(SyncDnsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getPeerConnId());
        internalRequest.addParameter("close", null);
        internalRequest.addParameter("role", request.getRole());
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

