/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bes;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bes.model.BesClusterDetailRequest;
import com.baidubce.services.bes.model.BesClusterDetailResponse;
import com.baidubce.services.bes.model.BesConfigTuple;
import com.baidubce.services.bes.model.BesCreateClusterRequest;
import com.baidubce.services.bes.model.BesCreateClusterResponse;
import com.baidubce.services.bes.model.BesDeleteClusterRequest;
import com.baidubce.services.bes.model.BesDeleteClusterResponse;
import com.baidubce.services.bes.model.BesListClusterRequest;
import com.baidubce.services.bes.model.BesListClusterResponse;
import com.baidubce.services.bes.model.BesResizeClusterRequest;
import com.baidubce.services.bes.model.BesStartClusterRequest;
import com.baidubce.services.bes.model.BesStartClusterResponse;
import com.baidubce.services.bes.model.BesStartInstanceRequest;
import com.baidubce.services.bes.model.BesStartInstanceResponse;
import com.baidubce.services.bes.model.BesStopClusterRequest;
import com.baidubce.services.bes.model.BesStopClusterResponse;
import com.baidubce.services.bes.model.BesStopInstanceRequest;
import com.baidubce.services.bes.model.BesStopInstanceResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class BesClient
extends AbstractBceClient {
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final String STOP_CLUSTER_URL = "api/bes/cluster/stop";
    private static final String START_CLUSTER_URL = "api/bes/cluster/start";
    private static final String DELETE_CLUSTER_URL = "api/bes/cluster/delete";
    private static final String CLUSTER_LIST_URL = "api/bes/cluster/list";
    private static final String CLUSTER_DETAIL_URL = "api/bes/cluster/detail";
    private static final String CREATE_CLUSTER_URL = "api/bes/cluster/create";
    private static final String RESIZE_CLUSTER_URL = "api/bes/cluster/resize";
    private static final String START_CLUSTER_INSTANCE_URL = "api/bes/cluster/instance/start";
    private static final String STOP_CLUSTER_INSTANCE_URL = "api/bes/cluster/instance/stop";
    private static final String X_REGION = "X-Region";
    private String region = "";
    private static final HttpResponseHandler[] BES_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BesClient() {
        this(new BceClientConfiguration());
    }

    public BesClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, BES_HANDLERS);
        this.region = this.getRegion(clientConfiguration.getEndpoint());
    }

    public BesStopClusterResponse stopCluster(BesStopClusterRequest besStopClusterRequest) {
        Preconditions.checkNotNull((Object)besStopClusterRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(besStopClusterRequest.getClusterId(), "The parameter clusterId should not be null or empty string.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("clusterId", besStopClusterRequest.getClusterId());
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(besStopClusterRequest, HttpMethodName.POST, STOP_CLUSTER_URL);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.setContent(RestartableInputStream.wrap(json));
        BesStopClusterResponse besStopClusterResponse = this.invokeHttpClient(internalRequest, BesStopClusterResponse.class);
        return besStopClusterResponse;
    }

    public BesStartClusterResponse startCluster(BesStartClusterRequest besStartClusterRequest) {
        Preconditions.checkNotNull((Object)besStartClusterRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(besStartClusterRequest.getClusterId(), "The parameter clusterId should not be null or empty string.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("clusterId", besStartClusterRequest.getClusterId());
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(besStartClusterRequest, HttpMethodName.POST, START_CLUSTER_URL);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.setContent(RestartableInputStream.wrap(json));
        BesStartClusterResponse besStartClusterResponse = this.invokeHttpClient(internalRequest, BesStartClusterResponse.class);
        return besStartClusterResponse;
    }

    public BesDeleteClusterResponse deleteCluster(BesDeleteClusterRequest besDeleteClusterRequest) {
        Preconditions.checkNotNull((Object)besDeleteClusterRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(besDeleteClusterRequest.getClusterId(), "The parameter clusterId should not be null or empty string.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("clusterId", besDeleteClusterRequest.getClusterId());
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(besDeleteClusterRequest, HttpMethodName.POST, DELETE_CLUSTER_URL);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.setContent(RestartableInputStream.wrap(json));
        BesDeleteClusterResponse besDeleteClusterResponse = this.invokeHttpClient(internalRequest, BesDeleteClusterResponse.class);
        return besDeleteClusterResponse;
    }

    public BesListClusterResponse clusterList(BesListClusterRequest besListClusterRequest) {
        Preconditions.checkNotNull((Object)besListClusterRequest, (Object)"request should not be null.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("pageNo", besListClusterRequest.getPageNo());
            jsonGenerator.writeNumberField("pageSize", besListClusterRequest.getPageSize());
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(besListClusterRequest, HttpMethodName.POST, CLUSTER_LIST_URL);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.setContent(RestartableInputStream.wrap(json));
        BesListClusterResponse deployResponse = this.invokeHttpClient(internalRequest, BesListClusterResponse.class);
        return deployResponse;
    }

    public BesClusterDetailResponse clusterDetail(BesClusterDetailRequest besClusterDetailRequest) {
        Preconditions.checkNotNull((Object)besClusterDetailRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(besClusterDetailRequest.getClusterId(), "The parameter clusterId should not be null or empty string.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("clusterId", besClusterDetailRequest.getClusterId());
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(besClusterDetailRequest, HttpMethodName.POST, CLUSTER_DETAIL_URL);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.setContent(RestartableInputStream.wrap(json));
        BesClusterDetailResponse deployResponse = this.invokeHttpClient(internalRequest, BesClusterDetailResponse.class);
        return deployResponse;
    }

    public BesCreateClusterResponse createCluster(BesCreateClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", request.getName());
            jsonGenerator.writeStringField("password", request.getPassword());
            jsonGenerator.writeArrayFieldStart("modules");
            for (BesCreateClusterRequest.ModuleInfo modules : request.getModules()) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("type", modules.getType());
                jsonGenerator.writeNumberField("instanceNum", modules.getInstanceNum());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            BesCreateClusterRequest.ClusterBilling billing = request.getBilling();
            jsonGenerator.writeObjectFieldStart("billing");
            jsonGenerator.writeStringField("payment", billing.getPayment());
            jsonGenerator.writeNumberField("time", billing.getTime());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeStringField("version", request.getVersion());
            jsonGenerator.writeStringField("slotType", request.getSlotType());
            jsonGenerator.writeBooleanField("isOpenService", request.isOpenService());
            jsonGenerator.writeStringField("availableZone", request.getAvailableZone());
            jsonGenerator.writeStringField("securityGroupId", request.getSecurityGroupId());
            jsonGenerator.writeStringField("subnetUuid", request.getSubnetUuid());
            jsonGenerator.writeStringField("vpcId", request.getVpcId());
            jsonGenerator.writeStringField("serviceType", request.getServiceType());
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CREATE_CLUSTER_URL);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.setContent(RestartableInputStream.wrap(json));
        BesCreateClusterResponse deployResponse = this.invokeHttpClient(internalRequest, BesCreateClusterResponse.class);
        return deployResponse;
    }

    public BesCreateClusterResponse resizeCluster(BesResizeClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("deployId", request.getDeployId());
            jsonGenerator.writeStringField("name", request.getName());
            jsonGenerator.writeStringField("region", request.getRegion());
            jsonGenerator.writeStringField("productType", request.getProductType());
            jsonGenerator.writeArrayFieldStart("modules");
            for (BesResizeClusterRequest.ModuleDesc module : request.getModules()) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("slot_type", module.getSlotType());
                jsonGenerator.writeNumberField("desireInstanceNum", module.getDesireInstanceNum());
                jsonGenerator.writeStringField("version", module.getVersion());
                jsonGenerator.writeStringField("type", module.getType());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeArrayFieldStart("configs");
            for (BesConfigTuple config : request.getConfigs()) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("id", config.getId());
                jsonGenerator.writeStringField("value", config.getValue());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, RESIZE_CLUSTER_URL);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.addParameter("orderType", "RESIZE");
        internalRequest.setContent(RestartableInputStream.wrap(json));
        BesCreateClusterResponse deployResponse = this.invokeHttpClient(internalRequest, BesCreateClusterResponse.class);
        return deployResponse;
    }

    public BesStartInstanceResponse startClusterInstance(BesStartInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("instanceId", request.getInstanceId());
            jsonGenerator.writeStringField("clusterId", request.getClusterId());
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, START_CLUSTER_INSTANCE_URL);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.setContent(RestartableInputStream.wrap(json));
        BesStartInstanceResponse besStartInstanceResponse = this.invokeHttpClient(internalRequest, BesStartInstanceResponse.class);
        return besStartInstanceResponse;
    }

    public BesStopInstanceResponse stopClusterInstance(BesStopInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("instanceId", request.getInstanceId());
            jsonGenerator.writeStringField("clusterId", request.getClusterId());
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, STOP_CLUSTER_INSTANCE_URL);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.setContent(RestartableInputStream.wrap(json));
        BesStopInstanceResponse besStopInstanceResponse = this.invokeHttpClient(internalRequest, BesStopInstanceResponse.class);
        return besStopInstanceResponse;
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private String aes128EncryptWithFirst16Char(String content, String privateKey) throws GeneralSecurityException {
        if (privateKey == null || privateKey.length() < 16) {
            throw new GeneralSecurityException("account secretKey is wrong");
        }
        byte[] crypted = null;
        SecretKeySpec skey = new SecretKeySpec(privateKey.substring(0, 16).getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        crypted = cipher.doFinal(content.getBytes());
        return new String(Hex.encodeHex((byte[])crypted));
    }

    private String getRegion(String endpoint) {
        String region = endpoint.split("\\.")[1];
        return region;
    }
}

