/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.as;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.as.AsGroupClientConfiguration;
import com.baidubce.services.as.model.asgroup.AdjustAsGroupRequest;
import com.baidubce.services.as.model.asgroup.AdjustAsGroupResponse;
import com.baidubce.services.as.model.asgroup.AsGroupAction;
import com.baidubce.services.as.model.asgroup.DecreaseAsGroupRequest;
import com.baidubce.services.as.model.asgroup.DecreaseAsGroupResponse;
import com.baidubce.services.as.model.asgroup.GetAsGroupRequest;
import com.baidubce.services.as.model.asgroup.GetAsGroupResponse;
import com.baidubce.services.as.model.asgroup.IncreaseAsGroupRequest;
import com.baidubce.services.as.model.asgroup.IncreaseAsGroupResponse;
import com.baidubce.services.as.model.asgroup.ListAsGroupRequest;
import com.baidubce.services.as.model.asgroup.ListAsGroupResponse;
import com.baidubce.services.as.model.asgroup.ListAsNodeRequest;
import com.baidubce.services.as.model.asgroup.ListAsNodeResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsGroupClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsGroupClient.class);
    private static final String VERSION = "v2";
    private static final String AS_GROUP = "asGroup";
    private static final String AS_NODE = "asNode";
    private static final String GROUP_NAME = "groupName";
    private static final String GROUP_ID = "groupId";
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] as_group_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public AsGroupClient() {
        this(new AsGroupClientConfiguration());
    }

    public AsGroupClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, as_group_handlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public ListAsGroupResponse listAsGroup(ListAsGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, AS_GROUP);
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (request.getGroupName() != null) {
            internalRequest.addParameter(GROUP_NAME, request.getGroupName());
        }
        return this.invokeHttpClient(internalRequest, ListAsGroupResponse.class);
    }

    public GetAsGroupResponse getAsGroup(GetAsGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, AS_GROUP, request.getGroupId());
        return this.invokeHttpClient(internalRequest, GetAsGroupResponse.class);
    }

    public IncreaseAsGroupResponse increaseAsGroup(IncreaseAsGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, AS_GROUP, request.getGroupId());
        internalRequest.addParameter(AsGroupAction.increase.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, IncreaseAsGroupResponse.class);
    }

    public DecreaseAsGroupResponse decreaseAsGroup(DecreaseAsGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, AS_GROUP, request.getGroupId());
        internalRequest.addParameter(AsGroupAction.decrease.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DecreaseAsGroupResponse.class);
    }

    public AdjustAsGroupResponse adjustAsGroup(AdjustAsGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_ID));
        Validate.checkIsTrue(request.getActionNum() >= 0, "The number of nodes cannot be negative");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, AS_GROUP, request.getGroupId());
        internalRequest.addParameter(AsGroupAction.adjust.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AdjustAsGroupResponse.class);
    }

    public ListAsNodeResponse listAsNode(ListAsNodeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_ID));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, AS_NODE, request.getGroupId());
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListAsNodeResponse.class);
    }
}

