/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.services.eip.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for creating a newly eip.
 */
public class CreateEipRequest extends AbstractBceRequest {
    /**
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/EIP/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     *   BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    /**
     * name of eip. The optional parameter
     */
    private String name;
    /**
     * specify the bandwidth in Mbps
     */
    private Integer bandwidthInMbps;
    /**
     * billing information. The optional parameter, default paymentTiming is Postpaid
     */
    private Billing billing;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getBandwidthInMbps() {
        return bandwidthInMbps;
    }

    public void setBandwidthInMbps(Integer bandwidthInMbps) {
        this.bandwidthInMbps = bandwidthInMbps;
    }

    public Billing getBilling() {
        return billing;
    }

    public void setBilling(Billing billing) {
        this.billing = billing;
    }

    public CreateEipRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public CreateEipRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CreateEipRequest withBandwidthInMbps(Integer bandwidthInMbps) {
        this.bandwidthInMbps = bandwidthInMbps;
        return this;
    }

    public CreateEipRequest withBilling(Billing billing) {
        this.billing = billing;
        return this;
    }

    public CreateEipRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
