/*
 * Copyright (c) 2019 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.blb.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.List;

/**
 * The request for delete appBlb policy.
 */
public class DeleteAppPolicyRequest extends AbstractBceRequest {

    /**
     * the blb id of the policy
     */
    private String blbId;
    /**
     * the port of the policy
     */
    private Integer port;
    /**
     * the id of the policy list
     */
    private List<String> policyIdList;

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    public DeleteAppPolicyRequest withBlbId(String blbId) {
        this.blbId = blbId;
        return this;
    }

    public DeleteAppPolicyRequest withPort(Integer port) {
        this.port = port;
        return this;
    }

    public DeleteAppPolicyRequest withPolicyIdList(List<String> policyIdList) {
        this.policyIdList = policyIdList;
        return this;
    }

    public String getBlbId() {
        return blbId;
    }

    public void setBlbId(String blbId) {
        this.blbId = blbId;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public List<String> getPolicyIdList() {
        return policyIdList;
    }

    public void setPolicyIdList(List<String> policyIdList) {
        this.policyIdList = policyIdList;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    @Override
    public DeleteAppPolicyRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
