/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class SecretRestoreParameters
implements JsonSerializable<SecretRestoreParameters> {
    private final Base64Url secretBundleBackup;

    public SecretRestoreParameters(byte[] secretBundleBackup) {
        this.secretBundleBackup = secretBundleBackup == null ? null : Base64Url.encode((byte[])secretBundleBackup);
    }

    public byte[] getSecretBundleBackup() {
        if (this.secretBundleBackup == null) {
            return null;
        }
        return this.secretBundleBackup.decodedBytes();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.secretBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    public static SecretRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SecretRestoreParameters)jsonReader.readObject(reader -> {
            byte[] secretBundleBackup = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    Base64Url secretBundleBackupHolder = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (secretBundleBackupHolder == null) continue;
                    secretBundleBackup = secretBundleBackupHolder.decodedBytes();
                    continue;
                }
                reader.skipChildren();
            }
            return new SecretRestoreParameters(secretBundleBackup);
        });
    }
}

