/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.transaction.SystemException;

public abstract class MessageProducerSession {
    private AbstractConnectionFactoryBean connectionFactoryBean;
    private String user;
    private String password;
    private Destination destination;
    private Destination replyToDestination;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    private transient Connection connection;
    private transient Session session;
    private transient MessageProducer sender;

    protected MessageProducerSession() {
        this.setTimeToLive(0L);
        this.setDeliveryMode(2);
        this.setPriority(4);
    }

    private synchronized MessageProducer refresh() throws JMSException {
        MessageProducer ret = null;
        if (this.destination == null) {
            throw new JMSException("Please call setDestination first!");
        }
        this.connection = this.user != null ? this.connectionFactoryBean.createConnection(this.user, this.password) : this.connectionFactoryBean.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(true, 0);
        this.sender = ret = this.session.createProducer(this.destination);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeResources() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                Configuration.logWarning((String)"Error closing JMS session", (Throwable)e);
                Configuration.logWarning((String)"MessageProducerSession: linked exception is ", (Throwable)e.getLinkedException());
            }
            finally {
                this.session = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                Configuration.logWarning((String)"Error closing JMS connection", (Throwable)e);
                Configuration.logWarning((String)"MessageProducerSession: linked exception is ", (Throwable)e.getLinkedException());
            }
            finally {
                this.connection = null;
            }
        }
        this.sender = null;
    }

    protected void setAbstractConnectionFactoryBean(AbstractConnectionFactoryBean bean) {
        this.connectionFactoryBean = bean;
    }

    protected AbstractConnectionFactoryBean getAbstractConnectionFactoryBean() {
        return this.connectionFactoryBean;
    }

    protected Destination getDestination() {
        return this.destination;
    }

    protected void setDestination(Destination destination) {
        this.destination = destination;
    }

    protected abstract String getDestinationName();

    protected abstract String getReplyToDestinationName();

    public void init() {
        StringBuffer msg = new StringBuffer();
        msg.append("MessageProducerSession configured with [");
        msg.append("user=").append(this.getUser()).append(", ");
        msg.append("password=").append(this.password).append(", ");
        msg.append("deliveryMode=").append(this.getDeliveryMode()).append(", ");
        msg.append("timeToLive=").append(this.getTimeToLive()).append(", ");
        msg.append("priority=").append(this.getPriority()).append(", ");
        msg.append("destination=").append(this.getDestinationName()).append(", ");
        msg.append("replyToDestination=").append(this.getReplyToDestinationName());
        msg.append("]");
        Configuration.logDebug((String)msg.toString());
    }

    public String getUser() {
        return this.user;
    }

    public void setReplyToDestination(Destination destination) {
        this.replyToDestination = destination;
    }

    public Destination getReplyToDestination() {
        return this.replyToDestination;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void sendMessage(Message message) throws JMSException {
        UserTransactionManager tm = new UserTransactionManager();
        try {
            if (tm.getStatus() != 0) {
                throw new JMSException("This method requires an active transaction!");
            }
        }
        catch (SystemException e) {
            Configuration.logWarning((String)"Error in getting transaction status", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        try {
            if (this.sender == null) {
                this.sender = this.refresh();
            }
            if (this.replyToDestination != null) {
                message.setJMSReplyTo(this.replyToDestination);
            }
            Configuration.logInfo((String)("Calling send ( " + message + " ,  " + this.deliveryMode + " , " + this.priority + " , " + this.timeToLive + " )..."));
            this.sender.send(message, this.deliveryMode, this.priority, this.timeToLive);
            Configuration.logDebug((String)"Send done!");
        }
        catch (JMSException e) {
            this.closeResources();
            this.sender = null;
            Configuration.logWarning((String)"MessageProducerSession: error in sending JMS message", (Throwable)e);
            Configuration.logWarning((String)"MessageProducerSession: linked exception is ", (Throwable)e.getLinkedException());
            throw e;
        }
    }

    public TextMessage createTextMessage() throws JMSException {
        TextMessage ret = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            ret = this.session.createTextMessage();
        }
        catch (JMSException e) {
            Configuration.logWarning((String)"MessageProducerSession: error creating new message", (Throwable)e);
            Configuration.logWarning((String)"MessageProducerSession: linked exception is ", (Throwable)e.getLinkedException());
            this.closeResources();
            throw e;
        }
        return ret;
    }

    public MapMessage createMapMessage() throws JMSException {
        MapMessage ret = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            ret = this.session.createMapMessage();
        }
        catch (JMSException e) {
            Configuration.logWarning((String)"MessageProducerSession: error creating new message", (Throwable)e);
            Configuration.logWarning((String)"MessageProducerSession: linked exception is ", (Throwable)e.getLinkedException());
            this.closeResources();
            throw e;
        }
        return ret;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessage ret = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            ret = this.session.createObjectMessage();
        }
        catch (JMSException e) {
            Configuration.logWarning((String)"MessageProducersession: error creating new message", (Throwable)e);
            Configuration.logWarning((String)"MessageProducerSession: linked exception is ", (Throwable)e.getLinkedException());
            this.closeResources();
            throw e;
        }
        return ret;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        BytesMessage ret = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            ret = this.session.createBytesMessage();
        }
        catch (JMSException e) {
            Configuration.logWarning((String)"MessageProducerSession: error creating new message", (Throwable)e);
            Configuration.logWarning((String)"MessageProducerSession: linked exception is ", (Throwable)e.getLinkedException());
            this.closeResources();
            throw e;
        }
        return ret;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        StreamMessage ret = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            ret = this.session.createStreamMessage();
        }
        catch (JMSException e) {
            Configuration.logWarning((String)"MessageProducerSession: error creating new message", (Throwable)e);
            Configuration.logWarning((String)"MessageProducerSession: linked exception is ", (Throwable)e.getLinkedException());
            this.closeResources();
            throw e;
        }
        return ret;
    }

    public void stop() {
        this.closeResources();
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setDeliveryMode(int i) {
        this.deliveryMode = i;
    }

    public void setPriority(int i) {
        this.priority = i;
    }

    public void setTimeToLive(long l) {
        this.timeToLive = l;
    }
}

