/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.incremental;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

public class DependencyData {
    @NonNull
    private String mMainFile;
    @NonNull
    private List<String> mSecondaryFiles = Lists.newArrayList();
    @NonNull
    private List<String> mOutputFiles = Lists.newArrayList();

    DependencyData() {
    }

    @NonNull
    public String getMainFile() {
        return this.mMainFile;
    }

    void setMainFile(String path) {
        this.mMainFile = path;
    }

    @NonNull
    public List<String> getSecondaryFiles() {
        return this.mSecondaryFiles;
    }

    void addSecondaryFile(String path) {
        this.mSecondaryFiles.add(path);
    }

    @NonNull
    public List<String> getOutputFiles() {
        return this.mOutputFiles;
    }

    void addOutputFile(String path) {
        this.mOutputFiles.add(path);
    }

    @Nullable
    public static DependencyData parseDependencyFile(@NonNull File dependencyFile) throws IOException {
        if (!dependencyFile.isFile()) {
            return null;
        }
        List content = Files.readLines((File)dependencyFile, (Charset)Charsets.UTF_8);
        return DependencyData.processDependencyData(content);
    }

    @Nullable
    static DependencyData processDependencyData(@NonNull List<String> content) {
        DependencyData data = new DependencyData();
        ParseMode parseMode = ParseMode.OUTPUT;
        for (String line : content) {
            if ((line = line.trim()).startsWith(":")) {
                parseMode = ParseMode.MAIN;
                line = line.substring(1).trim();
            }
            ParseMode nextMode = parseMode;
            if (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 1).trim();
            }
            if (line.endsWith(":")) {
                nextMode = ParseMode.MAIN;
                line = line.substring(0, line.length() - 1).trim();
            }
            if (!line.isEmpty()) {
                switch (parseMode) {
                    case OUTPUT: {
                        data.addOutputFile(line);
                        break;
                    }
                    case MAIN: {
                        data.setMainFile(line);
                        nextMode = ParseMode.SECONDARY;
                        break;
                    }
                    case SECONDARY: {
                        data.addSecondaryFile(line);
                    }
                }
            }
            parseMode = nextMode;
        }
        if (data.getMainFile() == null) {
            return null;
        }
        return data;
    }

    public String toString() {
        return "DependencyData{mMainFile='" + this.mMainFile + '\'' + ", mSecondaryFiles=" + this.mSecondaryFiles + ", mOutputFiles=" + this.mOutputFiles + '}';
    }

    private static enum ParseMode {
        OUTPUT,
        MAIN,
        SECONDARY;

    }
}

