/*
 * Copyright 2010-2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.simpleemail.model.transform;

import java.util.Map;
import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;

import com.amazonaws.services.simpleemail.model.*;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * Send Data Point StAX Unmarshaller
 */
public class SendDataPointStaxUnmarshaller implements Unmarshaller<SendDataPoint, StaxUnmarshallerContext> {

    public SendDataPoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        SendDataPoint sendDataPoint = new SendDataPoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument()) targetDepth += 2;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) return sendDataPoint;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Timestamp", targetDepth)) {
                    sendDataPoint.setTimestamp(DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeliveryAttempts", targetDepth)) {
                    sendDataPoint.setDeliveryAttempts(LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Bounces", targetDepth)) {
                    sendDataPoint.setBounces(LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Complaints", targetDepth)) {
                    sendDataPoint.setComplaints(LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Rejects", targetDepth)) {
                    sendDataPoint.setRejects(LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return sendDataPoint;
                }
            }
        }
    }

    private static SendDataPointStaxUnmarshaller instance;
    public static SendDataPointStaxUnmarshaller getInstance() {
        if (instance == null) instance = new SendDataPointStaxUnmarshaller();
        return instance;
    }
}
    