/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.SplitDocument;
import java.util.List;

@SdkInternalApi
public class SplitDocumentMarshaller {
    private static final MarshallingInfo<Integer> INDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Index").build();
    private static final MarshallingInfo<List> PAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pages").build();
    private static final SplitDocumentMarshaller instance = new SplitDocumentMarshaller();

    public static SplitDocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(SplitDocument splitDocument, ProtocolMarshaller protocolMarshaller) {
        if (splitDocument == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)splitDocument.getIndex(), INDEX_BINDING);
            protocolMarshaller.marshall(splitDocument.getPages(), PAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

