/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.spring;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.spring.POJOWorkflowStubImplementationFactory;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.HashMap;
import java.util.Map;

class SpringWorkflowDefinitionFactoryFactory
extends WorkflowDefinitionFactoryFactory {
    private final POJOWorkflowDefinitionFactoryFactory impl = new POJOWorkflowDefinitionFactoryFactory(){

        @Override
        protected POJOWorkflowImplementationFactory getImplementationFactory(Class<?> workflowImplementationType, Class<?> workflowInteface, WorkflowType workflowType) {
            Object instanceProxy = SpringWorkflowDefinitionFactoryFactory.this.workflowImplementations.get(workflowImplementationType);
            if (instanceProxy == null) {
                throw new IllegalArgumentException("unknown workflowImplementationType: " + workflowImplementationType);
            }
            return new POJOWorkflowStubImplementationFactory(instanceProxy);
        }
    };
    private final Map<Class<?>, Object> workflowImplementations = new HashMap();

    SpringWorkflowDefinitionFactoryFactory() {
    }

    @Override
    public WorkflowDefinitionFactory getWorkflowDefinitionFactory(WorkflowType workflowType) {
        return this.impl.getWorkflowDefinitionFactory(workflowType);
    }

    @Override
    public Iterable<WorkflowType> getWorkflowTypesToRegister() {
        return this.impl.getWorkflowTypesToRegister();
    }

    public void setWorkflowImplementations(Iterable<Object> workflowImplementations) throws InstantiationException, IllegalAccessException {
        for (Object workflowImplementation : workflowImplementations) {
            this.addWorkflowImplementation(workflowImplementation);
        }
    }

    public Iterable<Object> getWorkflowImplementations() {
        return this.workflowImplementations.values();
    }

    public void addWorkflowImplementation(Object workflowImplementation) throws InstantiationException, IllegalAccessException {
        Class<?> implementationClass = workflowImplementation.getClass();
        this.workflowImplementations.put(implementationClass, workflowImplementation);
        this.impl.addWorkflowImplementationType(implementationClass);
    }

    public DataConverter getDataConverter() {
        return this.impl.getDataConverter();
    }

    public void setDataConverter(DataConverter converter) {
        this.impl.setDataConverter(converter);
    }
}

