/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.resourcegroups.model.GroupConfigurationItem;
import com.amazonaws.services.resourcegroups.model.ResourceQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private ResourceQuery resourceQuery;
    private Map<String, String> tags;
    private List<GroupConfigurationItem> configuration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateGroupRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateGroupRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setResourceQuery(ResourceQuery resourceQuery) {
        this.resourceQuery = resourceQuery;
    }

    public ResourceQuery getResourceQuery() {
        return this.resourceQuery;
    }

    public CreateGroupRequest withResourceQuery(ResourceQuery resourceQuery) {
        this.setResourceQuery(resourceQuery);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateGroupRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateGroupRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateGroupRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<GroupConfigurationItem> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Collection<GroupConfigurationItem> configuration) {
        if (configuration == null) {
            this.configuration = null;
            return;
        }
        this.configuration = new ArrayList<GroupConfigurationItem>(configuration);
    }

    public CreateGroupRequest withConfiguration(GroupConfigurationItem ... configuration) {
        if (this.configuration == null) {
            this.setConfiguration(new ArrayList<GroupConfigurationItem>(configuration.length));
        }
        for (GroupConfigurationItem ele : configuration) {
            this.configuration.add(ele);
        }
        return this;
    }

    public CreateGroupRequest withConfiguration(Collection<GroupConfigurationItem> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getResourceQuery() != null) {
            sb.append("ResourceQuery: ").append(this.getResourceQuery()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getResourceQuery() == null ^ this.getResourceQuery() == null) {
            return false;
        }
        if (other.getResourceQuery() != null && !other.getResourceQuery().equals(this.getResourceQuery())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        return other.getConfiguration() == null || other.getConfiguration().equals(this.getConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getResourceQuery() == null ? 0 : this.getResourceQuery().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        return hashCode;
    }

    public CreateGroupRequest clone() {
        return (CreateGroupRequest)super.clone();
    }
}

