/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataPathValue;
import com.amazonaws.services.quicksight.model.SortDirection;
import com.amazonaws.services.quicksight.model.transform.DataPathSortMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataPathSort
implements Serializable,
Cloneable,
StructuredPojo {
    private String direction;
    private List<DataPathValue> sortPaths;

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getDirection() {
        return this.direction;
    }

    public DataPathSort withDirection(String direction) {
        this.setDirection(direction);
        return this;
    }

    public DataPathSort withDirection(SortDirection direction) {
        this.direction = direction.toString();
        return this;
    }

    public List<DataPathValue> getSortPaths() {
        return this.sortPaths;
    }

    public void setSortPaths(Collection<DataPathValue> sortPaths) {
        if (sortPaths == null) {
            this.sortPaths = null;
            return;
        }
        this.sortPaths = new ArrayList<DataPathValue>(sortPaths);
    }

    public DataPathSort withSortPaths(DataPathValue ... sortPaths) {
        if (this.sortPaths == null) {
            this.setSortPaths(new ArrayList<DataPathValue>(sortPaths.length));
        }
        for (DataPathValue ele : sortPaths) {
            this.sortPaths.add(ele);
        }
        return this;
    }

    public DataPathSort withSortPaths(Collection<DataPathValue> sortPaths) {
        this.setSortPaths(sortPaths);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirection() != null) {
            sb.append("Direction: ").append(this.getDirection()).append(",");
        }
        if (this.getSortPaths() != null) {
            sb.append("SortPaths: ").append(this.getSortPaths());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPathSort)) {
            return false;
        }
        DataPathSort other = (DataPathSort)obj;
        if (other.getDirection() == null ^ this.getDirection() == null) {
            return false;
        }
        if (other.getDirection() != null && !other.getDirection().equals(this.getDirection())) {
            return false;
        }
        if (other.getSortPaths() == null ^ this.getSortPaths() == null) {
            return false;
        }
        return other.getSortPaths() == null || other.getSortPaths().equals(this.getSortPaths());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirection() == null ? 0 : this.getDirection().hashCode());
        hashCode = 31 * hashCode + (this.getSortPaths() == null ? 0 : this.getSortPaths().hashCode());
        return hashCode;
    }

    public DataPathSort clone() {
        try {
            return (DataPathSort)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataPathSortMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

