/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.MessageResult;
import com.amazonaws.services.pinpoint.model.transform.MessageResponseMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MessageResponse
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationId;
    private String requestId;
    private Map<String, MessageResult> result;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public MessageResponse withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public MessageResponse withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public Map<String, MessageResult> getResult() {
        return this.result;
    }

    public void setResult(Map<String, MessageResult> result) {
        this.result = result;
    }

    public MessageResponse withResult(Map<String, MessageResult> result) {
        this.setResult(result);
        return this;
    }

    public MessageResponse addResultEntry(String key, MessageResult value) {
        if (null == this.result) {
            this.result = new HashMap<String, MessageResult>();
        }
        if (this.result.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.result.put(key, value);
        return this;
    }

    public MessageResponse clearResultEntries() {
        this.result = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getResult() != null) {
            sb.append("Result: ").append(this.getResult());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageResponse)) {
            return false;
        }
        MessageResponse other = (MessageResponse)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getResult() == null ^ this.getResult() == null) {
            return false;
        }
        return other.getResult() == null || other.getResult().equals(this.getResult());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getResult() == null ? 0 : this.getResult().hashCode());
        return hashCode;
    }

    public MessageResponse clone() {
        try {
            return (MessageResponse)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

