/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medicalimaging.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medicalimaging.model.Operator;
import com.amazonaws.services.medicalimaging.model.SearchByAttributeValue;
import com.amazonaws.services.medicalimaging.model.transform.SearchFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SearchByAttributeValue> values;
    private String operator;

    public List<SearchByAttributeValue> getValues() {
        return this.values;
    }

    public void setValues(Collection<SearchByAttributeValue> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<SearchByAttributeValue>(values);
    }

    public SearchFilter withValues(SearchByAttributeValue ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<SearchByAttributeValue>(values.length));
        }
        for (SearchByAttributeValue ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public SearchFilter withValues(Collection<SearchByAttributeValue> values) {
        this.setValues(values);
        return this;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public SearchFilter withOperator(String operator) {
        this.setOperator(operator);
        return this;
    }

    public SearchFilter withOperator(Operator operator) {
        this.operator = operator.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues()).append(",");
        }
        if (this.getOperator() != null) {
            sb.append("Operator: ").append(this.getOperator());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFilter)) {
            return false;
        }
        SearchFilter other = (SearchFilter)obj;
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        if (other.getValues() != null && !other.getValues().equals(this.getValues())) {
            return false;
        }
        if (other.getOperator() == null ^ this.getOperator() == null) {
            return false;
        }
        return other.getOperator() == null || other.getOperator().equals(this.getOperator());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        hashCode = 31 * hashCode + (this.getOperator() == null ? 0 : this.getOperator().hashCode());
        return hashCode;
    }

    public SearchFilter clone() {
        try {
            return (SearchFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SearchFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

