/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.BoxConfiguration;
import java.util.List;

@SdkInternalApi
public class BoxConfigurationMarshaller {
    private static final MarshallingInfo<String> ENTERPRISEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnterpriseId").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretArn").build();
    private static final MarshallingInfo<Boolean> USECHANGELOG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseChangeLog").build();
    private static final MarshallingInfo<Boolean> CRAWLCOMMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlComments").build();
    private static final MarshallingInfo<Boolean> CRAWLTASKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlTasks").build();
    private static final MarshallingInfo<Boolean> CRAWLWEBLINKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlWebLinks").build();
    private static final MarshallingInfo<List> FILEFIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileFieldMappings").build();
    private static final MarshallingInfo<List> TASKFIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskFieldMappings").build();
    private static final MarshallingInfo<List> COMMENTFIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommentFieldMappings").build();
    private static final MarshallingInfo<List> WEBLINKFIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebLinkFieldMappings").build();
    private static final MarshallingInfo<List> INCLUSIONPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InclusionPatterns").build();
    private static final MarshallingInfo<List> EXCLUSIONPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusionPatterns").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfiguration").build();
    private static final BoxConfigurationMarshaller instance = new BoxConfigurationMarshaller();

    public static BoxConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(BoxConfiguration boxConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (boxConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)boxConfiguration.getEnterpriseId(), ENTERPRISEID_BINDING);
            protocolMarshaller.marshall((Object)boxConfiguration.getSecretArn(), SECRETARN_BINDING);
            protocolMarshaller.marshall((Object)boxConfiguration.getUseChangeLog(), USECHANGELOG_BINDING);
            protocolMarshaller.marshall((Object)boxConfiguration.getCrawlComments(), CRAWLCOMMENTS_BINDING);
            protocolMarshaller.marshall((Object)boxConfiguration.getCrawlTasks(), CRAWLTASKS_BINDING);
            protocolMarshaller.marshall((Object)boxConfiguration.getCrawlWebLinks(), CRAWLWEBLINKS_BINDING);
            protocolMarshaller.marshall(boxConfiguration.getFileFieldMappings(), FILEFIELDMAPPINGS_BINDING);
            protocolMarshaller.marshall(boxConfiguration.getTaskFieldMappings(), TASKFIELDMAPPINGS_BINDING);
            protocolMarshaller.marshall(boxConfiguration.getCommentFieldMappings(), COMMENTFIELDMAPPINGS_BINDING);
            protocolMarshaller.marshall(boxConfiguration.getWebLinkFieldMappings(), WEBLINKFIELDMAPPINGS_BINDING);
            protocolMarshaller.marshall(boxConfiguration.getInclusionPatterns(), INCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall(boxConfiguration.getExclusionPatterns(), EXCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall((Object)boxConfiguration.getVpcConfiguration(), VPCCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

