/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableUtils {
    private static final int DEFAULT_WAIT_TIMEOUT = 600000;
    private static final int DEFAULT_WAIT_INTERVAL = 20000;
    private static final Log LOG = LogFactory.getLog(TableUtils.class);

    public static void waitUntilExists(AmazonDynamoDB dynamo, String tableName) throws InterruptedException {
        TableUtils.waitUntilExists(dynamo, tableName, 600000, 20000);
    }

    public static void waitUntilExists(AmazonDynamoDB dynamo, String tableName, int timeout, int interval) throws InterruptedException {
        TableDescription table = TableUtils.waitForTableDescription(dynamo, tableName, null, timeout, interval);
        if (table == null) {
            throw new AmazonClientException("Table " + tableName + " never returned a result");
        }
    }

    public static void waitUntilActive(AmazonDynamoDB dynamo, String tableName) throws InterruptedException, TableNeverTransitionedToStateException {
        TableUtils.waitUntilActive(dynamo, tableName, 600000, 20000);
    }

    public static void waitUntilActive(AmazonDynamoDB dynamo, String tableName, int timeout, int interval) throws InterruptedException, TableNeverTransitionedToStateException {
        TableDescription table = TableUtils.waitForTableDescription(dynamo, tableName, TableStatus.ACTIVE, timeout, interval);
        if (table == null || !table.getTableStatus().equals(TableStatus.ACTIVE.toString())) {
            throw new TableNeverTransitionedToStateException(tableName, TableStatus.ACTIVE);
        }
    }

    private static TableDescription waitForTableDescription(AmazonDynamoDB dynamo, String tableName, TableStatus desiredStatus, int timeout, int interval) throws InterruptedException, IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        if (interval <= 0 || interval >= timeout) {
            throw new IllegalArgumentException("Interval must be > 0 and < timeout");
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        TableDescription table = null;
        while (System.currentTimeMillis() < endTime) {
            try {
                table = dynamo.describeTable(new DescribeTableRequest(tableName)).getTable();
                if (desiredStatus == null || table.getTableStatus().equals(desiredStatus.toString())) {
                    return table;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
            Thread.sleep(interval);
        }
        return table;
    }

    public static final boolean createTableIfNotExists(AmazonDynamoDB dynamo, CreateTableRequest createTableRequest) {
        try {
            dynamo.createTable(createTableRequest);
            return true;
        }
        catch (ResourceInUseException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Table " + createTableRequest.getTableName() + " already exists"), (Throwable)((Object)e));
            }
            return false;
        }
    }

    public static final boolean deleteTableIfExists(AmazonDynamoDB dynamo, DeleteTableRequest deleteTableRequest) {
        try {
            dynamo.deleteTable(deleteTableRequest);
            return true;
        }
        catch (ResourceNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Table " + deleteTableRequest.getTableName() + " does not exist"), (Throwable)((Object)e));
            }
            return false;
        }
    }

    public static class TableNeverTransitionedToStateException
    extends AmazonClientException {
        private static final long serialVersionUID = 8920567021104846647L;

        public TableNeverTransitionedToStateException(String tableName, TableStatus desiredStatus) {
            super("Table " + tableName + " never transitioned to desired state of " + desiredStatus.toString());
        }
    }
}

