/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ListResourceScanRelatedResourcesRequest;
import com.amazonaws.services.cloudformation.model.ScannedResourceIdentifier;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class ListResourceScanRelatedResourcesRequestMarshaller
implements Marshaller<Request<ListResourceScanRelatedResourcesRequest>, ListResourceScanRelatedResourcesRequest> {
    public Request<ListResourceScanRelatedResourcesRequest> marshall(ListResourceScanRelatedResourcesRequest listResourceScanRelatedResourcesRequest) {
        if (listResourceScanRelatedResourcesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listResourceScanRelatedResourcesRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ListResourceScanRelatedResources");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listResourceScanRelatedResourcesRequest.getResourceScanId() != null) {
            request.addParameter("ResourceScanId", StringUtils.fromString((String)listResourceScanRelatedResourcesRequest.getResourceScanId()));
        }
        if (listResourceScanRelatedResourcesRequest.getResources().isEmpty() && !((SdkInternalList)listResourceScanRelatedResourcesRequest.getResources()).isAutoConstruct()) {
            request.addParameter("Resources", "");
        }
        if (!listResourceScanRelatedResourcesRequest.getResources().isEmpty() || !((SdkInternalList)listResourceScanRelatedResourcesRequest.getResources()).isAutoConstruct()) {
            SdkInternalList resourcesList = (SdkInternalList)listResourceScanRelatedResourcesRequest.getResources();
            int resourcesListIndex = 1;
            for (ScannedResourceIdentifier resourcesListValue : resourcesList) {
                if (resourcesListValue != null) {
                    Map<String, String> resourceIdentifier;
                    if (resourcesListValue.getResourceType() != null) {
                        request.addParameter("Resources.member." + resourcesListIndex + ".ResourceType", StringUtils.fromString((String)resourcesListValue.getResourceType()));
                    }
                    if ((resourceIdentifier = resourcesListValue.getResourceIdentifier()) != null) {
                        int resourceIdentifierListIndex = 1;
                        for (Map.Entry<String, String> entry : resourceIdentifier.entrySet()) {
                            if (entry != null && entry.getKey() != null) {
                                request.addParameter("Resources.member." + resourcesListIndex + ".ResourceIdentifier.entry." + resourceIdentifierListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                            }
                            if (entry != null && entry.getValue() != null) {
                                request.addParameter("Resources.member." + resourcesListIndex + ".ResourceIdentifier.entry." + resourceIdentifierListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                            }
                            ++resourceIdentifierListIndex;
                        }
                    }
                }
                ++resourcesListIndex;
            }
        }
        if (listResourceScanRelatedResourcesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listResourceScanRelatedResourcesRequest.getNextToken()));
        }
        if (listResourceScanRelatedResourcesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)listResourceScanRelatedResourcesRequest.getMaxResults()));
        }
        return request;
    }
}

