/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteStackRequestMarshaller
implements Marshaller<Request<DeleteStackRequest>, DeleteStackRequest> {
    public Request<DeleteStackRequest> marshall(DeleteStackRequest deleteStackRequest) {
        if (deleteStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteStackRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DeleteStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteStackRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)deleteStackRequest.getStackName()));
        }
        if (deleteStackRequest.getRetainResources().isEmpty() && !((SdkInternalList)deleteStackRequest.getRetainResources()).isAutoConstruct()) {
            request.addParameter("RetainResources", "");
        }
        if (!deleteStackRequest.getRetainResources().isEmpty() || !((SdkInternalList)deleteStackRequest.getRetainResources()).isAutoConstruct()) {
            SdkInternalList retainResourcesList = (SdkInternalList)deleteStackRequest.getRetainResources();
            int retainResourcesListIndex = 1;
            for (String retainResourcesListValue : retainResourcesList) {
                if (retainResourcesListValue != null) {
                    request.addParameter("RetainResources.member." + retainResourcesListIndex, StringUtils.fromString((String)retainResourcesListValue));
                }
                ++retainResourcesListIndex;
            }
        }
        if (deleteStackRequest.getRoleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)deleteStackRequest.getRoleARN()));
        }
        if (deleteStackRequest.getClientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)deleteStackRequest.getClientRequestToken()));
        }
        return request;
    }
}

