/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cleanrooms.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.cleanrooms.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AnalysisRuleListMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AnalysisRuleListMarshaller {

    private static final MarshallingInfo<List> JOINCOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("joinColumns").build();
    private static final MarshallingInfo<List> ALLOWEDJOINOPERATORS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedJoinOperators").build();
    private static final MarshallingInfo<List> LISTCOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("listColumns").build();
    private static final MarshallingInfo<String> ADDITIONALANALYSES_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalAnalyses").build();

    private static final AnalysisRuleListMarshaller instance = new AnalysisRuleListMarshaller();

    public static AnalysisRuleListMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AnalysisRuleList analysisRuleList, ProtocolMarshaller protocolMarshaller) {

        if (analysisRuleList == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(analysisRuleList.getJoinColumns(), JOINCOLUMNS_BINDING);
            protocolMarshaller.marshall(analysisRuleList.getAllowedJoinOperators(), ALLOWEDJOINOPERATORS_BINDING);
            protocolMarshaller.marshall(analysisRuleList.getListColumns(), LISTCOLUMNS_BINDING);
            protocolMarshaller.marshall(analysisRuleList.getAdditionalAnalyses(), ADDITIONALANALYSES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
