/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.batch.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.batch.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * EksPodPropertiesMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class EksPodPropertiesMarshaller {

    private static final MarshallingInfo<String> SERVICEACCOUNTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceAccountName").build();
    private static final MarshallingInfo<Boolean> HOSTNETWORK_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostNetwork").build();
    private static final MarshallingInfo<String> DNSPOLICY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("dnsPolicy").build();
    private static final MarshallingInfo<List> IMAGEPULLSECRETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imagePullSecrets").build();
    private static final MarshallingInfo<List> CONTAINERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("containers").build();
    private static final MarshallingInfo<List> INITCONTAINERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("initContainers").build();
    private static final MarshallingInfo<List> VOLUMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("volumes").build();
    private static final MarshallingInfo<StructuredPojo> METADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadata").build();
    private static final MarshallingInfo<Boolean> SHAREPROCESSNAMESPACE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("shareProcessNamespace").build();

    private static final EksPodPropertiesMarshaller instance = new EksPodPropertiesMarshaller();

    public static EksPodPropertiesMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(EksPodProperties eksPodProperties, ProtocolMarshaller protocolMarshaller) {

        if (eksPodProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(eksPodProperties.getServiceAccountName(), SERVICEACCOUNTNAME_BINDING);
            protocolMarshaller.marshall(eksPodProperties.getHostNetwork(), HOSTNETWORK_BINDING);
            protocolMarshaller.marshall(eksPodProperties.getDnsPolicy(), DNSPOLICY_BINDING);
            protocolMarshaller.marshall(eksPodProperties.getImagePullSecrets(), IMAGEPULLSECRETS_BINDING);
            protocolMarshaller.marshall(eksPodProperties.getContainers(), CONTAINERS_BINDING);
            protocolMarshaller.marshall(eksPodProperties.getInitContainers(), INITCONTAINERS_BINDING);
            protocolMarshaller.marshall(eksPodProperties.getVolumes(), VOLUMES_BINDING);
            protocolMarshaller.marshall(eksPodProperties.getMetadata(), METADATA_BINDING);
            protocolMarshaller.marshall(eksPodProperties.getShareProcessNamespace(), SHAREPROCESSNAMESPACE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
