/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.servlet;

import com.amazon.ask.Skill;
import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.model.RequestEnvelope;
import com.amazon.ask.model.services.Serializer;
import com.amazon.ask.request.SkillRequest;
import com.amazon.ask.request.impl.BaseSkillRequest;
import com.amazon.ask.response.SkillResponse;
import com.amazon.ask.servlet.util.ServletUtils;
import com.amazon.ask.servlet.verifiers.ServletRequest;
import com.amazon.ask.servlet.verifiers.SkillRequestSignatureVerifier;
import com.amazon.ask.servlet.verifiers.SkillRequestTimestampVerifier;
import com.amazon.ask.servlet.verifiers.SkillServletVerifier;
import com.amazon.ask.util.JacksonSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkillServlet.class);
    private static final long serialVersionUID = 3257254794185762002L;
    private final transient Skill skill;
    private final transient List<SkillServletVerifier> verifiers;
    private final transient Serializer serializer = new JacksonSerializer();

    public SkillServlet(Skill skill) {
        Long timestampToleranceProperty;
        ArrayList<SkillServletVerifier> defaultVerifiers = new ArrayList<SkillServletVerifier>();
        if (!ServletUtils.isRequestSignatureCheckSystemPropertyDisabled().booleanValue()) {
            defaultVerifiers.add(new SkillRequestSignatureVerifier());
        }
        defaultVerifiers.add(new SkillRequestTimestampVerifier((timestampToleranceProperty = ServletUtils.getTimeStampToleranceSystemProperty()) != null ? timestampToleranceProperty : 30000L));
        this.skill = skill;
        this.verifiers = defaultVerifiers;
    }

    SkillServlet(Skill skill, List<SkillServletVerifier> verifiers) {
        this.skill = skill;
        this.verifiers = verifiers;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block28: {
            byte[] serializedRequestEnvelope = IOUtils.toByteArray((InputStream)request.getInputStream());
            try {
                RequestEnvelope deserializedRequestEnvelope = (RequestEnvelope)this.serializer.deserialize(IOUtils.toString((byte[])serializedRequestEnvelope, (String)"UTF-8"), RequestEnvelope.class);
                ServletRequest alexaHttpRequest = new ServletRequest(request, serializedRequestEnvelope, deserializedRequestEnvelope);
                for (SkillServletVerifier verifier : this.verifiers) {
                    verifier.verify(alexaHttpRequest);
                }
                try (ByteArrayOutputStream skillResponse = new ByteArrayOutputStream();){
                    this.handleRequest(new ByteArrayInputStream(serializedRequestEnvelope), skillResponse);
                    response.setContentType("application/json");
                    response.setStatus(200);
                    byte[] serializedResponse = skillResponse.toByteArray();
                    if (skillResponse == null) break block28;
                    try (ServletOutputStream out = response.getOutputStream();){
                        response.setContentLength(serializedResponse.length);
                        out.write(serializedResponse);
                    }
                }
            }
            catch (SecurityException ex) {
                int statusCode = 400;
                LOGGER.error("Incoming request failed verification {}", (Object)statusCode, (Object)ex);
                response.sendError(statusCode, ex.getMessage());
            }
            catch (AskSdkException ex) {
                int statusCode = 500;
                LOGGER.error("Exception occurred in doPost, returning status code {}", (Object)statusCode, (Object)ex);
                response.sendError(statusCode, ex.getMessage());
            }
        }
    }

    public final void handleRequest(InputStream input, OutputStream output) throws IOException {
        byte[] inputBytes = IOUtils.toByteArray((InputStream)input);
        BaseSkillRequest skillRequest = new BaseSkillRequest(inputBytes);
        SkillResponse skillResponse = this.skill.execute((SkillRequest)skillRequest);
        if (skillResponse != null) {
            if (skillResponse.isPresent()) {
                skillResponse.writeTo(output);
            }
        } else {
            String message = "Unable to find a suitable request handler";
            LOGGER.error(message);
            throw new AskSdkException(message);
        }
    }

    public void setProxy(Proxy proxy) {
        if (this.verifiers.removeIf(verifier -> verifier instanceof SkillRequestSignatureVerifier)) {
            this.verifiers.add(new SkillRequestSignatureVerifier(proxy));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("Skill servlet is not serializable");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("Skill servlet is not serializable");
    }
}

