/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.services.listManagement.ListItemState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class CreateListItemRequest {
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="status")
    private String status = null;

    private CreateListItemRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private CreateListItemRequest(Builder builder) {
        if (builder.value != null) {
            this.value = builder.value;
        }
        if (builder.status != null) {
            this.status = builder.status;
        }
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public ListItemState getStatus() {
        return ListItemState.fromValue(this.status);
    }

    @JsonProperty(value="status")
    public String getStatusAsString() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateListItemRequest servicesListManagementCreateListItemRequest = (CreateListItemRequest)o;
        return Objects.equals(this.value, servicesListManagementCreateListItemRequest.value) && Objects.equals(this.status, servicesListManagementCreateListItemRequest.status);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateListItemRequest {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String value;
        private String status;

        private Builder() {
        }

        @JsonProperty(value="value")
        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="status")
        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withStatus(ListItemState status) {
            this.status = status != null ? status.toString() : null;
            return this;
        }

        public CreateListItemRequest build() {
            return new CreateListItemRequest(this);
        }
    }
}

