/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.datastore.v1;

import com.amazon.ask.model.services.datastore.v1.Command;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class PutObjectCommand
extends Command {
    @JsonProperty(value="namespace")
    private String namespace = null;
    @JsonProperty(value="key")
    private String key = null;
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private Object content = null;

    private PutObjectCommand() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private PutObjectCommand(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "PUT_OBJECT";
        if (builder.namespace != null) {
            this.namespace = builder.namespace;
        }
        if (builder.key != null) {
            this.key = builder.key;
        }
        if (builder.content != null) {
            this.content = builder.content;
        }
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="content")
    public Object getContent() {
        return this.content;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutObjectCommand servicesDatastoreV1PutObjectCommand = (PutObjectCommand)o;
        return Objects.equals(this.namespace, servicesDatastoreV1PutObjectCommand.namespace) && Objects.equals(this.key, servicesDatastoreV1PutObjectCommand.key) && Objects.equals(this.content, servicesDatastoreV1PutObjectCommand.content) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.namespace, this.key, this.content, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PutObjectCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String namespace;
        private String key;
        private Object content;

        private Builder() {
        }

        @JsonProperty(value="namespace")
        public Builder withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="key")
        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="content")
        public Builder withContent(Object content) {
            this.content = content;
            return this;
        }

        public PutObjectCommand build() {
            return new PutObjectCommand(this);
        }
    }
}

