/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.viewport;

import com.amazon.ask.model.interfaces.viewport.Experience;
import com.amazon.ask.model.interfaces.viewport.Keyboard;
import com.amazon.ask.model.interfaces.viewport.Mode;
import com.amazon.ask.model.interfaces.viewport.Shape;
import com.amazon.ask.model.interfaces.viewport.Touch;
import com.amazon.ask.model.interfaces.viewport.ViewportStateVideo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ViewportState {
    @JsonProperty(value="experiences")
    private List<Experience> experiences = new ArrayList<Experience>();
    @JsonProperty(value="mode")
    private String mode = null;
    @JsonProperty(value="shape")
    private String shape = null;
    @JsonProperty(value="pixelWidth")
    private BigDecimal pixelWidth = null;
    @JsonProperty(value="pixelHeight")
    private BigDecimal pixelHeight = null;
    @JsonProperty(value="dpi")
    private BigDecimal dpi = null;
    @JsonProperty(value="currentPixelWidth")
    private BigDecimal currentPixelWidth = null;
    @JsonProperty(value="currentPixelHeight")
    private BigDecimal currentPixelHeight = null;
    @JsonProperty(value="touch")
    private List<Touch> touch = new ArrayList<Touch>();
    @JsonProperty(value="keyboard")
    private List<Keyboard> keyboard = new ArrayList<Keyboard>();
    @JsonProperty(value="video")
    private ViewportStateVideo video = null;

    private ViewportState() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ViewportState(Builder builder) {
        if (builder.experiences != null) {
            this.experiences = builder.experiences;
        }
        if (builder.mode != null) {
            this.mode = builder.mode;
        }
        if (builder.shape != null) {
            this.shape = builder.shape;
        }
        if (builder.pixelWidth != null) {
            this.pixelWidth = builder.pixelWidth;
        }
        if (builder.pixelHeight != null) {
            this.pixelHeight = builder.pixelHeight;
        }
        if (builder.dpi != null) {
            this.dpi = builder.dpi;
        }
        if (builder.currentPixelWidth != null) {
            this.currentPixelWidth = builder.currentPixelWidth;
        }
        if (builder.currentPixelHeight != null) {
            this.currentPixelHeight = builder.currentPixelHeight;
        }
        if (builder.touch != null) {
            this.touch = builder.touch;
        }
        if (builder.keyboard != null) {
            this.keyboard = builder.keyboard;
        }
        if (builder.video != null) {
            this.video = builder.video;
        }
    }

    @JsonProperty(value="experiences")
    public List<Experience> getExperiences() {
        return this.experiences;
    }

    public Mode getMode() {
        return Mode.fromValue(this.mode);
    }

    @JsonProperty(value="mode")
    public String getModeAsString() {
        return this.mode;
    }

    public Shape getShape() {
        return Shape.fromValue(this.shape);
    }

    @JsonProperty(value="shape")
    public String getShapeAsString() {
        return this.shape;
    }

    @JsonProperty(value="pixelWidth")
    public BigDecimal getPixelWidth() {
        return this.pixelWidth;
    }

    @JsonProperty(value="pixelHeight")
    public BigDecimal getPixelHeight() {
        return this.pixelHeight;
    }

    @JsonProperty(value="dpi")
    public BigDecimal getDpi() {
        return this.dpi;
    }

    @JsonProperty(value="currentPixelWidth")
    public BigDecimal getCurrentPixelWidth() {
        return this.currentPixelWidth;
    }

    @JsonProperty(value="currentPixelHeight")
    public BigDecimal getCurrentPixelHeight() {
        return this.currentPixelHeight;
    }

    @JsonProperty(value="touch")
    public List<Touch> getTouch() {
        return this.touch;
    }

    @JsonProperty(value="keyboard")
    public List<Keyboard> getKeyboard() {
        return this.keyboard;
    }

    @JsonProperty(value="video")
    public ViewportStateVideo getVideo() {
        return this.video;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewportState interfacesViewportViewportState = (ViewportState)o;
        return Objects.equals(this.experiences, interfacesViewportViewportState.experiences) && Objects.equals(this.mode, interfacesViewportViewportState.mode) && Objects.equals(this.shape, interfacesViewportViewportState.shape) && Objects.equals(this.pixelWidth, interfacesViewportViewportState.pixelWidth) && Objects.equals(this.pixelHeight, interfacesViewportViewportState.pixelHeight) && Objects.equals(this.dpi, interfacesViewportViewportState.dpi) && Objects.equals(this.currentPixelWidth, interfacesViewportViewportState.currentPixelWidth) && Objects.equals(this.currentPixelHeight, interfacesViewportViewportState.currentPixelHeight) && Objects.equals(this.touch, interfacesViewportViewportState.touch) && Objects.equals(this.keyboard, interfacesViewportViewportState.keyboard) && Objects.equals(this.video, interfacesViewportViewportState.video);
    }

    public int hashCode() {
        return Objects.hash(this.experiences, this.mode, this.shape, this.pixelWidth, this.pixelHeight, this.dpi, this.currentPixelWidth, this.currentPixelHeight, this.touch, this.keyboard, this.video);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViewportState {\n");
        sb.append("    experiences: ").append(this.toIndentedString(this.experiences)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    shape: ").append(this.toIndentedString(this.shape)).append("\n");
        sb.append("    pixelWidth: ").append(this.toIndentedString(this.pixelWidth)).append("\n");
        sb.append("    pixelHeight: ").append(this.toIndentedString(this.pixelHeight)).append("\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    currentPixelWidth: ").append(this.toIndentedString(this.currentPixelWidth)).append("\n");
        sb.append("    currentPixelHeight: ").append(this.toIndentedString(this.currentPixelHeight)).append("\n");
        sb.append("    touch: ").append(this.toIndentedString(this.touch)).append("\n");
        sb.append("    keyboard: ").append(this.toIndentedString(this.keyboard)).append("\n");
        sb.append("    video: ").append(this.toIndentedString(this.video)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private List<Experience> experiences;
        private String mode;
        private String shape;
        private BigDecimal pixelWidth;
        private BigDecimal pixelHeight;
        private BigDecimal dpi;
        private BigDecimal currentPixelWidth;
        private BigDecimal currentPixelHeight;
        private List<Touch> touch;
        private List<Keyboard> keyboard;
        private ViewportStateVideo video;

        private Builder() {
        }

        @JsonProperty(value="experiences")
        public Builder withExperiences(List<Experience> experiences) {
            this.experiences = experiences;
            return this;
        }

        public Builder addExperiencesItem(Experience experiencesItem) {
            if (this.experiences == null) {
                this.experiences = new ArrayList<Experience>();
            }
            this.experiences.add(experiencesItem);
            return this;
        }

        @JsonProperty(value="mode")
        public Builder withMode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder withMode(Mode mode) {
            this.mode = mode != null ? mode.toString() : null;
            return this;
        }

        @JsonProperty(value="shape")
        public Builder withShape(String shape) {
            this.shape = shape;
            return this;
        }

        public Builder withShape(Shape shape) {
            this.shape = shape != null ? shape.toString() : null;
            return this;
        }

        @JsonProperty(value="pixelWidth")
        public Builder withPixelWidth(BigDecimal pixelWidth) {
            this.pixelWidth = pixelWidth;
            return this;
        }

        @JsonProperty(value="pixelHeight")
        public Builder withPixelHeight(BigDecimal pixelHeight) {
            this.pixelHeight = pixelHeight;
            return this;
        }

        @JsonProperty(value="dpi")
        public Builder withDpi(BigDecimal dpi) {
            this.dpi = dpi;
            return this;
        }

        @JsonProperty(value="currentPixelWidth")
        public Builder withCurrentPixelWidth(BigDecimal currentPixelWidth) {
            this.currentPixelWidth = currentPixelWidth;
            return this;
        }

        @JsonProperty(value="currentPixelHeight")
        public Builder withCurrentPixelHeight(BigDecimal currentPixelHeight) {
            this.currentPixelHeight = currentPixelHeight;
            return this;
        }

        @JsonProperty(value="touch")
        public Builder withTouch(List<Touch> touch) {
            this.touch = touch;
            return this;
        }

        public Builder addTouchItem(Touch touchItem) {
            if (this.touch == null) {
                this.touch = new ArrayList<Touch>();
            }
            this.touch.add(touchItem);
            return this;
        }

        @JsonProperty(value="keyboard")
        public Builder withKeyboard(List<Keyboard> keyboard) {
            this.keyboard = keyboard;
            return this;
        }

        public Builder addKeyboardItem(Keyboard keyboardItem) {
            if (this.keyboard == null) {
                this.keyboard = new ArrayList<Keyboard>();
            }
            this.keyboard.add(keyboardItem);
            return this;
        }

        @JsonProperty(value="video")
        public Builder withVideo(ViewportStateVideo video) {
            this.video = video;
            return this;
        }

        public ViewportState build() {
            return new ViewportState(this);
        }
    }
}

