/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.messaging;

import com.amazon.ask.model.Request;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class MessageReceivedRequest
extends Request {
    @JsonProperty(value="message")
    private Map<String, Object> message = new HashMap<String, Object>();

    private MessageReceivedRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private MessageReceivedRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Messaging.MessageReceived";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.message != null) {
            this.message = builder.message;
        }
    }

    @JsonProperty(value="message")
    public Map<String, Object> getMessage() {
        return this.message;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageReceivedRequest interfacesMessagingMessageReceivedRequest = (MessageReceivedRequest)o;
        return Objects.equals(this.message, interfacesMessagingMessageReceivedRequest.message) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.message, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageReceivedRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private Map<String, Object> message;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="message")
        public Builder withMessage(Map<String, Object> message) {
            this.message = message;
            return this;
        }

        public Builder putMessageItem(String key, Object messageItem) {
            if (this.message == null) {
                this.message = new HashMap<String, Object>();
            }
            this.message.put(key, messageItem);
            return this;
        }

        public MessageReceivedRequest build() {
            return new MessageReceivedRequest(this);
        }
    }
}

