/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.datastore.packagemanager;

import com.amazon.ask.model.interfaces.alexa.datastore.packagemanager.ErrorType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class PackageError {
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="content")
    private Object content = null;

    private PackageError() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private PackageError(Builder builder) {
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.content != null) {
            this.content = builder.content;
        }
    }

    public ErrorType getType() {
        return ErrorType.fromValue(this.type);
    }

    @JsonProperty(value="type")
    public String getTypeAsString() {
        return this.type;
    }

    @JsonProperty(value="content")
    public Object getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageError interfacesAlexaDatastorePackagemanagerPackageError = (PackageError)o;
        return Objects.equals(this.type, interfacesAlexaDatastorePackagemanagerPackageError.type) && Objects.equals(this.content, interfacesAlexaDatastorePackagemanagerPackageError.content);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.content);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackageError {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String type;
        private Object content;

        private Builder() {
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withType(ErrorType type) {
            this.type = type != null ? type.toString() : null;
            return this;
        }

        @JsonProperty(value="content")
        public Builder withContent(Object content) {
            this.content = content;
            return this;
        }

        public PackageError build() {
            return new PackageError(this);
        }
    }
}

