/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.lwa.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(builder=Builder.class)
public class AccessTokenRequest {
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="client_secret")
    private String clientSecret;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="scope")
    private String scope;

    private AccessTokenRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.refreshToken = builder.refreshToken;
        this.scope = builder.scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private String refreshToken;
        private String scope;

        private Builder() {
        }

        @JsonProperty(value="client_id")
        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @JsonProperty(value="client_secret")
        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @JsonProperty(value="refresh_token")
        public Builder withRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @JsonProperty(value="scope")
        public Builder withScope(String scope) {
            this.scope = scope;
            return this;
        }

        public AccessTokenRequest build() {
            return new AccessTokenRequest(this);
        }
    }
}

