/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.verifier;

import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.verifier.SpeechletResponseVerifier;
import com.amazon.speech.ui.Card;
import com.amazon.speech.ui.Image;
import com.amazon.speech.ui.SimpleCard;
import com.amazon.speech.ui.StandardCard;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardSpeechletResponseVerifier
implements SpeechletResponseVerifier {
    private static final Logger log = LoggerFactory.getLogger(CardSpeechletResponseVerifier.class);
    private static final int MAX_CARD_SIZE = 8000;
    protected static final int MAX_URL_LENGTH = 2000;
    private static final String VALID_IMAGE_PROTOCOL = "https";

    @Override
    public boolean verify(SpeechletResponseEnvelope responseEnvelope, Session session) {
        if (responseEnvelope == null || responseEnvelope.getResponse() == null) {
            return true;
        }
        Card card = responseEnvelope.getResponse().getCard();
        if (card instanceof SimpleCard) {
            SimpleCard simpleCard = (SimpleCard)card;
            this.verifyCardSize(simpleCard.getTitle(), simpleCard.getContent());
        } else if (card instanceof StandardCard) {
            StandardCard standardCard = (StandardCard)card;
            Image image = standardCard.getImage();
            if (image != null) {
                this.verifyCardSize(standardCard.getTitle(), standardCard.getText(), image.getSmallImageUrl(), image.getLargeImageUrl());
            } else {
                this.verifyCardSize(standardCard.getTitle(), standardCard.getText());
            }
            this.verifyImageAttributes(standardCard);
        }
        return true;
    }

    private void verifyCardSize(String ... cardElements) {
        int cardSize = 0;
        for (String element : cardElements) {
            cardSize += StringUtils.length((CharSequence)element);
        }
        if (cardSize > 8000) {
            log.warn("Card with size {} exceeds the maximum allowed size of {} and will be rejected by the Alexa service", (Object)cardSize, (Object)8000);
        }
    }

    private void verifyImageAttributes(StandardCard card) {
        Image image = card.getImage();
        if (image != null) {
            this.verifyImageUrl("smallImageUrl", image.getSmallImageUrl());
            this.verifyImageUrl("largeImageUrl", image.getLargeImageUrl());
        }
    }

    private void verifyImageUrl(String imageUrlType, String imageUrl) {
        if (imageUrl != null) {
            this.verifyLengthImageUrl(imageUrlType, imageUrl);
            this.verifyProtocolImageUrl(imageUrlType, imageUrl);
        }
    }

    private void verifyLengthImageUrl(String imageUrlType, String imageUrl) {
        int length = imageUrl.length();
        if (2000 < length) {
            log.warn("The length of {} exceeds the maximum allowed of {} for the image of the card of type StandardCard.", (Object)imageUrlType, (Object)length);
        }
    }

    private void verifyProtocolImageUrl(String imageType, String imageUrl) {
        try {
            URL url = new URL(imageUrl);
            String protocol = url.getProtocol();
            if (!VALID_IMAGE_PROTOCOL.equals(protocol)) {
                log.warn("{} with value {} is invalid for the image of the card of type StandardCard since HTTPS is required", (Object)imageType, (Object)imageUrl);
            }
        }
        catch (MalformedURLException e) {
            log.warn("{} with value {} is malformed for the image of the card of type StandardCard", (Object)imageType, (Object)imageUrl);
        }
    }
}

