/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.interfaces.system;

import com.amazon.speech.speechlet.interfaces.system.ErrorType;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.Validate;

public final class Error {
    private final ErrorType type;
    private final String message;

    public static Builder builder() {
        return new Builder();
    }

    public Error(Builder builder) {
        this.type = builder.type;
        this.message = builder.message;
    }

    private Error(@JsonProperty(value="type") ErrorType type, @JsonProperty(value="message") String message) {
        this.type = type;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public ErrorType getType() {
        return this.type;
    }

    public static final class Builder {
        private ErrorType type;
        private String message;

        private Builder() {
        }

        public Builder withType(ErrorType type) {
            this.type = type;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Error build() {
            Validate.notNull((Object)((Object)this.type), (String)"Type must be defined", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.message, (String)"Message must be non-blank", (Object[])new Object[0]);
            return new Error(this);
        }
    }
}

