/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.interfaces.audioplayer.request;

import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.CurrentPlaybackState;
import com.amazon.speech.speechlet.interfaces.audioplayer.Error;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.AudioPlayerRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="AudioPlayer.PlaybackFailed")
public class PlaybackFailedRequest
extends AudioPlayerRequest {
    private final CurrentPlaybackState currentPlaybackState;
    private final Error error;
    private final String token;

    public static Builder builder() {
        return new Builder();
    }

    private PlaybackFailedRequest(Builder builder) {
        super(builder);
        this.currentPlaybackState = builder.currentPlaybackState;
        this.error = builder.error;
        this.token = builder.token;
    }

    private PlaybackFailedRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="currentPlaybackState") CurrentPlaybackState currentPlaybackState, @JsonProperty(value="error") Error error, @JsonProperty(value="token") String token) {
        super(requestId, timestamp, locale);
        this.currentPlaybackState = currentPlaybackState;
        this.error = error;
        this.token = token;
    }

    public CurrentPlaybackState getCurrentPlaybackState() {
        return this.currentPlaybackState;
    }

    public Error getError() {
        return this.error;
    }

    public String getToken() {
        return this.token;
    }

    public static final class Builder
    extends SpeechletRequest.SpeechletRequestBuilder<Builder, PlaybackFailedRequest> {
        private CurrentPlaybackState currentPlaybackState;
        private Error error;
        private String token;

        private Builder() {
        }

        public Builder withCurrentPlaybackState(CurrentPlaybackState currentPlaybackState) {
            this.currentPlaybackState = currentPlaybackState;
            return this;
        }

        public Builder withError(Error error) {
            this.error = error;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @Override
        public PlaybackFailedRequest build() {
            Validate.notBlank((CharSequence)this.getRequestId(), (String)"RequestId must be defined", (Object[])new Object[0]);
            return new PlaybackFailedRequest(this);
        }
    }
}

