/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.Interface;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SupportedInterfaces {
    private final Map<Class<? extends Interface>, Interface> supportedInterfaces;

    public static Builder builder() {
        return new Builder();
    }

    private SupportedInterfaces(Builder builder) {
        this.supportedInterfaces = Collections.unmodifiableMap(builder.supportedInterfaces);
    }

    public <T extends Interface> boolean isInterfaceSupported(Class<T> clazz) {
        return this.supportedInterfaces != null && this.supportedInterfaces.containsKey(clazz);
    }

    public <T extends Interface> T getSupportedInterface(Class<T> clazz) {
        if (!this.isInterfaceSupported(clazz)) {
            return null;
        }
        return (T)this.supportedInterfaces.get(clazz);
    }

    public static final class Builder {
        private Map<Class<? extends Interface>, Interface> supportedInterfaces = new HashMap<Class<? extends Interface>, Interface>();

        private Builder() {
        }

        public Builder addSupportedInterface(Interface supportedInterface) {
            this.supportedInterfaces.put(supportedInterface.getClass(), supportedInterface);
            return this;
        }

        public SupportedInterfaces build() {
            return new SupportedInterfaces(this);
        }
    }
}

