/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.json.SpeechletRequestEnvelope;
import com.amazon.speech.speechlet.IntentRequest;
import com.amazon.speech.speechlet.LaunchRequest;
import com.amazon.speech.speechlet.SessionEndedRequest;
import com.amazon.speech.speechlet.SessionStartedRequest;
import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletException;
import com.amazon.speech.speechlet.SpeechletResponse;
import com.amazon.speech.speechlet.SpeechletV2;

public class SpeechletToSpeechletV2Adapter
implements SpeechletV2 {
    private final Speechlet speechlet;

    public SpeechletToSpeechletV2Adapter(Speechlet speechlet) {
        this.speechlet = speechlet;
    }

    @Override
    public void onSessionStarted(SpeechletRequestEnvelope<SessionStartedRequest> requestEnvelope) {
        try {
            this.speechlet.onSessionStarted(requestEnvelope.getRequest(), requestEnvelope.getSession());
        }
        catch (SpeechletException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SpeechletResponse onLaunch(SpeechletRequestEnvelope<LaunchRequest> requestEnvelope) {
        try {
            return this.speechlet.onLaunch(requestEnvelope.getRequest(), requestEnvelope.getSession());
        }
        catch (SpeechletException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SpeechletResponse onIntent(SpeechletRequestEnvelope<IntentRequest> requestEnvelope) {
        try {
            return this.speechlet.onIntent(requestEnvelope.getRequest(), requestEnvelope.getSession());
        }
        catch (SpeechletException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onSessionEnded(SpeechletRequestEnvelope<SessionEndedRequest> requestEnvelope) {
        try {
            this.speechlet.onSessionEnded(requestEnvelope.getRequest(), requestEnvelope.getSession());
        }
        catch (SpeechletException e) {
            throw new RuntimeException(e);
        }
    }

    public Speechlet getSpeechlet() {
        return this.speechlet;
    }
}

