/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.json.SpeechletRequestEnvelope;
import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletException;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.SpeechletRequestDispatcher;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.SpeechletToSpeechletV2Adapter;
import com.amazon.speech.speechlet.SpeechletV2;
import com.amazon.speech.speechlet.verifier.ApplicationIdSpeechletRequestEnvelopeVerifier;
import com.amazon.speech.speechlet.verifier.ApplicationIdSpeechletRequestVerifier;
import com.amazon.speech.speechlet.verifier.CardSpeechletResponseVerifier;
import com.amazon.speech.speechlet.verifier.OutputSpeechSpeechletResponseVerifier;
import com.amazon.speech.speechlet.verifier.ResponseSizeSpeechletResponseVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletRequestEnvelopeVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletRequestVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletResponseVerifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SpeechletRequestHandler {
    private final List<SpeechletRequestVerifier> requestVerifiers;
    private final List<SpeechletRequestEnvelopeVerifier> requestEnvelopeVerifiers;
    private final List<SpeechletResponseVerifier> responseVerifiers;

    @Deprecated
    public SpeechletRequestHandler(List<SpeechletRequestVerifier> requestVerifiers, List<SpeechletResponseVerifier> responseVerifiers) {
        this(new ArrayList<SpeechletRequestEnvelopeVerifier>(1), requestVerifiers, responseVerifiers);
        this.addApplicationIdSpeechletRequestEnvelopeVerifierIfNecessary();
    }

    public SpeechletRequestHandler(List<SpeechletRequestEnvelopeVerifier> requestEnvelopeVerifiers) {
        this(requestEnvelopeVerifiers, Collections.emptyList(), Arrays.asList(new ResponseSizeSpeechletResponseVerifier(), new OutputSpeechSpeechletResponseVerifier(), new CardSpeechletResponseVerifier()));
    }

    private SpeechletRequestHandler(List<SpeechletRequestEnvelopeVerifier> requestEnvelopeVerifiers, List<SpeechletRequestVerifier> requestVerifiers, List<SpeechletResponseVerifier> responseVerifiers) {
        this.requestEnvelopeVerifiers = requestEnvelopeVerifiers;
        this.requestVerifiers = requestVerifiers;
        this.responseVerifiers = responseVerifiers;
    }

    @Deprecated
    public byte[] handleSpeechletCall(Speechlet speechlet, byte[] serializedSpeechletRequest) throws IOException, SpeechletRequestHandlerException, SpeechletException {
        return this.internalHandleSpeechletCall(new SpeechletToSpeechletV2Adapter(speechlet), serializedSpeechletRequest);
    }

    public byte[] handleSpeechletCall(SpeechletV2 speechlet, byte[] serializedSpeechletRequest) throws IOException, SpeechletRequestHandlerException, SpeechletException {
        return this.internalHandleSpeechletCall(speechlet, serializedSpeechletRequest);
    }

    private byte[] internalHandleSpeechletCall(SpeechletV2 speechlet, byte[] serializedSpeechletRequest) throws IOException, SpeechletRequestHandlerException, SpeechletException {
        SpeechletRequestEnvelope<?> requestEnvelope = SpeechletRequestEnvelope.fromJson(serializedSpeechletRequest);
        Object request = requestEnvelope.getRequest();
        Session session = requestEnvelope.getSession();
        for (SpeechletRequestVerifier speechletRequestVerifier : this.requestVerifiers) {
            if (speechletRequestVerifier.verify((SpeechletRequest)request, session)) continue;
            String message = String.format("Could not validate SpeechletRequest %s using verifier %s, rejecting request", request != null ? ((SpeechletRequest)request).getRequestId() : "null", speechletRequestVerifier.getClass().getSimpleName());
            throw new SpeechletRequestHandlerException(message);
        }
        for (SpeechletRequestEnvelopeVerifier speechletRequestEnvelopeVerifier : this.requestEnvelopeVerifiers) {
            if (speechletRequestEnvelopeVerifier.verify(requestEnvelope)) continue;
            String message = String.format("Could not validate SpeechletRequest %s using verifier %s, rejecting request", request != null ? ((SpeechletRequest)request).getRequestId() : "null", speechletRequestEnvelopeVerifier.getClass().getSimpleName());
            throw new SpeechletRequestHandlerException(message);
        }
        SpeechletRequestDispatcher dispatcher = new SpeechletRequestDispatcher(speechlet);
        SpeechletResponseEnvelope speechletResponseEnvelope = dispatcher.dispatchSpeechletCall(requestEnvelope, session);
        for (SpeechletResponseVerifier verifier : this.responseVerifiers) {
            if (verifier.verify(speechletResponseEnvelope, session)) continue;
            String message = String.format("Could not validate SpeechletResponse %s using verifier %s, rejecting response", ((SpeechletRequest)request).getRequestId(), verifier.getClass().getSimpleName());
            throw new SpeechletRequestHandlerException(message);
        }
        return speechletResponseEnvelope.toJsonBytes();
    }

    private void addApplicationIdSpeechletRequestEnvelopeVerifierIfNecessary() {
        for (SpeechletRequestVerifier requestVerifier : this.requestVerifiers) {
            if (!(requestVerifier instanceof ApplicationIdSpeechletRequestVerifier)) continue;
            Set<String> supportedApplicationIds = ((ApplicationIdSpeechletRequestVerifier)requestVerifier).getSupportedApplicationIds();
            this.requestEnvelopeVerifiers.add(new ApplicationIdSpeechletRequestEnvelopeVerifier(supportedApplicationIds));
        }
    }
}

