/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.Interface;
import com.amazon.speech.speechlet.State;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Context {
    private final Map<Class<? extends Interface>, State<?>> states;

    public static Builder builder() {
        return new Builder();
    }

    private Context(Builder builder) {
        this.states = Collections.unmodifiableMap(builder.states);
    }

    public <T extends Interface> boolean hasState(Class<T> clazz) {
        return this.states != null && this.states.containsKey(clazz);
    }

    public <T extends Interface, S extends State<T>> S getState(Class<T> interfaceClass, Class<S> castClass) {
        if (!this.hasState(interfaceClass)) {
            return null;
        }
        State<?> stateForInterface = this.states.get(interfaceClass);
        return (S)stateForInterface;
    }

    public static final class Builder {
        private Map<Class<? extends Interface>, State<?>> states = new HashMap();

        private Builder() {
        }

        public Builder addState(State<? extends Interface> state) {
            this.states.put(state.getInterfaceClass(), state);
            return this;
        }

        public Context build() {
            return new Context(this);
        }
    }
}

