/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.GenericRequest;

public class ListObjectsRequest
extends GenericRequest {
    private static final int MAX_RETURNED_KEYS_LIMIT = 1000;
    private String prefix;
    private String marker;
    private Integer maxKeys;
    private String delimiter;
    private String encodingType;

    public ListObjectsRequest() {
    }

    public ListObjectsRequest(String bucketName) {
        this(bucketName, null, null, null, null);
    }

    public ListObjectsRequest(String bucketName, String prefix, String marker, String delimiter, Integer maxKeys) {
        super(bucketName);
        this.setPrefix(prefix);
        this.setMarker(marker);
        this.setDelimiter(delimiter);
        if (maxKeys != null) {
            this.setMaxKeys(maxKeys);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public ListObjectsRequest withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListObjectsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        if (maxKeys < 0 || maxKeys > 1000) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MaxKeysOutOfRange"));
        }
        this.maxKeys = maxKeys;
    }

    public ListObjectsRequest withMaxKeys(Integer maxKeys) {
        this.setMaxKeys(maxKeys);
        return this;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public ListObjectsRequest withDelimiter(String delimiter) {
        this.setDelimiter(delimiter);
        return this;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public ListObjectsRequest withEncodingType(String encodingType) {
        this.setEncodingType(encodingType);
        return this;
    }
}

