/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.bean;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import java.util.Map;
import java.util.Properties;

public class OrderConsumerBean
implements OrderConsumer {
    private Properties properties;
    private Map<Subscription, MessageOrderListener> subscriptionTable;
    private OrderConsumer orderConsumer;

    @Override
    public boolean isStarted() {
        return this.orderConsumer.isStarted();
    }

    @Override
    public boolean isClosed() {
        return this.orderConsumer.isClosed();
    }

    @Override
    public void start() {
        if (null == this.properties) {
            throw new ONSClientException("properties not set");
        }
        if (null == this.subscriptionTable) {
            throw new ONSClientException("subscriptionTable not set");
        }
        this.orderConsumer = ONSFactory.createOrderedConsumer(this.properties);
        for (Map.Entry<Subscription, MessageOrderListener> next : this.subscriptionTable.entrySet()) {
            this.subscribe(next.getKey().getTopic(), next.getKey().getExpression(), next.getValue());
        }
        this.orderConsumer.start();
    }

    @Override
    public void shutdown() {
        if (this.orderConsumer != null) {
            this.orderConsumer.shutdown();
        }
    }

    @Override
    public void subscribe(String topic, String subExpression, MessageOrderListener listener) {
        if (null == this.orderConsumer) {
            throw new ONSClientException("subscribe must be called after OrderConsumerBean started");
        }
        this.orderConsumer.subscribe(topic, subExpression, listener);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<Subscription, MessageOrderListener> getSubscriptionTable() {
        return this.subscriptionTable;
    }

    public void setSubscriptionTable(Map<Subscription, MessageOrderListener> subscriptionTable) {
        this.subscriptionTable = subscriptionTable;
    }
}

