/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import net.sf.launch4j.Util;
import net.sf.launch4j.config.ClassPath;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersisterException;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.Splash;
import net.sf.launch4j.config.VersionInfo;

public class ConfigPersister {
    private static final ConfigPersister _instance = new ConfigPersister();
    private final XStream _xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
    private Config _config;
    private File _configPath;

    private ConfigPersister() {
        this._xstream.alias("launch4jConfig", Config.class);
        this._xstream.alias("classPath", ClassPath.class);
        this._xstream.alias("jre", Jre.class);
        this._xstream.alias("splash", Splash.class);
        this._xstream.alias("versionInfo", VersionInfo.class);
        this._xstream.addImplicitCollection(Config.class, "headerObjects", "obj", String.class);
        this._xstream.addImplicitCollection(Config.class, "libs", "lib", String.class);
        this._xstream.addImplicitCollection(Config.class, "variables", "var", String.class);
        this._xstream.addImplicitCollection(ClassPath.class, "paths", "cp", String.class);
        this._xstream.addImplicitCollection(Jre.class, "options", "opt", String.class);
    }

    public static ConfigPersister getInstance() {
        return _instance;
    }

    public Config getConfig() {
        return this._config;
    }

    public File getConfigPath() {
        return this._configPath;
    }

    public File getOutputPath() throws IOException {
        if (this._config.getOutfile().isAbsolute()) {
            return this._config.getOutfile().getParentFile();
        }
        File parent = this._config.getOutfile().getParentFile();
        return parent != null ? new File(this._configPath, parent.getPath()) : this._configPath;
    }

    public File getOutputFile() throws IOException {
        return this._config.getOutfile().isAbsolute() ? this._config.getOutfile() : new File(this.getOutputPath(), this._config.getOutfile().getName());
    }

    public void createBlank() {
        this._config = new Config();
        this._config.setJre(new Jre());
        this._configPath = null;
    }

    public void setAntConfig(Config c, File basedir) {
        this._config = c;
        this._configPath = basedir;
    }

    public void load(File f) throws ConfigPersisterException {
        try {
            FileReader r = new FileReader(f);
            char[] buf = new char[(int)f.length()];
            r.read(buf);
            r.close();
            String s = String.valueOf(buf).replaceAll("<headerType>0<", "<headerType>gui<").replaceAll("<headerType>1<", "<headerType>console<").replaceAll("jarArgs>", "cmdLine>").replaceAll("<jarArgs[ ]*/>", "<cmdLine/>").replaceAll("args>", "opt>").replaceAll("<args[ ]*/>", "<opt/>").replaceAll("<dontUsePrivateJres>false</dontUsePrivateJres>", "<jdkPreference>preferJre</jdkPreference>").replaceAll("<dontUsePrivateJres>true</dontUsePrivateJres>", "<jdkPreference>jreOnly</jdkPreference>").replaceAll("<initialHeapSize>0</initialHeapSize>", "").replaceAll("<maxHeapSize>0</maxHeapSize>", "");
            this._config = (Config)this._xstream.fromXML(s);
            this.setConfigPath(f);
        }
        catch (Exception e) {
            throw new ConfigPersisterException(e);
        }
    }

    public void loadVersion1(File f) throws ConfigPersisterException {
        try {
            Props props = new Props(f);
            this._config = new Config();
            String header = props.getProperty("header");
            this._config.setHeaderType(header == null || header.toLowerCase().equals("guihead.bin") ? "gui" : "console");
            this._config.setJar(props.getFile("jar"));
            this._config.setOutfile(props.getFile("outfile"));
            this._config.setJre(new Jre());
            this._config.getJre().setPath(props.getProperty("jrepath"));
            this._config.getJre().setMinVersion(props.getProperty("javamin"));
            this._config.getJre().setMaxVersion(props.getProperty("javamax"));
            String args = props.getProperty("jvmArgs");
            if (args != null) {
                ArrayList<String> jreOptions = new ArrayList<String>();
                jreOptions.add(args);
                this._config.getJre().setOptions(jreOptions);
            }
            this._config.setCmdLine(props.getProperty("jarArgs"));
            this._config.setChdir("true".equals(props.getProperty("chdir")) ? "." : null);
            this._config.setCustomProcName("true".equals(props.getProperty("setProcName")));
            this._config.setStayAlive("true".equals(props.getProperty("stayAlive")));
            this._config.setErrTitle(props.getProperty("errTitle"));
            this._config.setIcon(props.getFile("icon"));
            File splashFile = props.getFile("splash");
            if (splashFile != null) {
                this._config.setSplash(new Splash());
                this._config.getSplash().setFile(splashFile);
                String waitfor = props.getProperty("waitfor");
                this._config.getSplash().setWaitForWindow(waitfor != null && !waitfor.equals(""));
                String splashTimeout = props.getProperty("splashTimeout");
                if (splashTimeout != null) {
                    this._config.getSplash().setTimeout(Integer.parseInt(splashTimeout));
                }
                this._config.getSplash().setTimeoutErr("true".equals(props.getProperty("splashTimeoutErr")));
            } else {
                this._config.setSplash(null);
            }
            this.setConfigPath(f);
        }
        catch (IOException e) {
            throw new ConfigPersisterException(e);
        }
    }

    public void save(File f) throws ConfigPersisterException {
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            this._xstream.toXML((Object)this._config, (Writer)w);
            w.close();
            this.setConfigPath(f);
        }
        catch (Exception e) {
            throw new ConfigPersisterException(e);
        }
    }

    private void setConfigPath(File configFile) {
        this._configPath = configFile.getAbsoluteFile().getParentFile();
    }

    private class Props {
        final Properties _properties = new Properties();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Props(File f) throws IOException {
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                this._properties.load(is);
            }
            catch (Throwable throwable) {
                Util.close(is);
                throw throwable;
            }
            Util.close(is);
        }

        public String getProperty(String key) {
            String p = this._properties.getProperty(key);
            if (p == null) {
                return null;
            }
            int x = p.indexOf(35);
            if (x == -1) {
                return p;
            }
            while (--x > 0 && (p.charAt(x) == ' ' || p.charAt(x) == '\t')) {
            }
            return x == 0 ? "" : p.substring(0, x + 1);
        }

        public File getFile(String key) {
            String value = this.getProperty(key);
            return value != null ? new File(value) : null;
        }
    }
}

