/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level;

import co.elastic.clients.transport.rest5_client.low_level.Node;
import co.elastic.clients.transport.rest5_client.low_level.Request;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

final class RequestLogger {
    private static final Log tracer = LogFactory.getLog(Request.class);

    private RequestLogger() {
    }

    static void logResponse(Log logger, HttpUriRequest request, HttpHost host, ClassicHttpResponse httpResponse) {
        Header[] warnings;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request [" + request.getMethod() + " " + String.valueOf(host) + RequestLogger.getUri(request.getRequestUri()) + "] returned [" + httpResponse.getCode() + "]"));
        }
        if (logger.isWarnEnabled() && (warnings = httpResponse.getHeaders("Warning")) != null && warnings.length > 0) {
            logger.warn((Object)RequestLogger.buildWarningMessage(request, host, warnings));
        }
        if (tracer.isTraceEnabled()) {
            String responseLine;
            String requestLine;
            try {
                requestLine = RequestLogger.buildTraceRequest(request, host);
            }
            catch (IOException | ParseException e) {
                requestLine = "";
                tracer.trace((Object)"error while reading request for trace purposes", e);
            }
            try {
                responseLine = RequestLogger.buildTraceResponse(httpResponse);
            }
            catch (IOException e) {
                responseLine = "";
                tracer.trace((Object)"error while reading response for trace purposes", (Throwable)e);
            }
            tracer.trace((Object)(requestLine + "\n" + responseLine));
        }
    }

    static void logFailedRequest(Log logger, HttpUriRequest request, Node node, Exception e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request [" + request.getMethod() + " " + String.valueOf(node.getHost()) + RequestLogger.getUri(request.getRequestUri()) + "] failed"), (Throwable)e);
        }
        if (tracer.isTraceEnabled()) {
            String traceRequest;
            try {
                traceRequest = RequestLogger.buildTraceRequest(request, node.getHost());
            }
            catch (IOException | ParseException e1) {
                tracer.trace((Object)"error while reading request for trace purposes", (Throwable)e);
                traceRequest = "";
            }
            tracer.trace((Object)traceRequest);
        }
    }

    static String buildWarningMessage(HttpUriRequest request, HttpHost host, Header[] warnings) {
        StringBuilder message = new StringBuilder("request [").append(request.getMethod()).append(" ").append(host).append(RequestLogger.getUri(request.getRequestUri())).append("] returned ").append(warnings.length).append(" warnings: ");
        for (int i = 0; i < warnings.length; ++i) {
            if (i > 0) {
                message.append(",");
            }
            message.append("[").append(warnings[i].getValue()).append("]");
        }
        return message.toString();
    }

    static String buildTraceRequest(HttpUriRequest request, HttpHost host) throws IOException, ParseException {
        String requestLine = "curl -iX " + request.getMethod() + " '" + String.valueOf(host) + RequestLogger.getUri(request.getRequestUri()) + "'";
        if (request.getEntity() != null) {
            requestLine = requestLine + " -d '";
            HttpEntity entity = request.getEntity();
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(request.getEntity());
                request.setEntity(entity);
            }
            requestLine = requestLine + EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8) + "'";
        }
        return requestLine;
    }

    static String buildTraceResponse(ClassicHttpResponse httpResponse) throws IOException {
        StringBuilder responseLine = new StringBuilder();
        responseLine.append("# ").append(httpResponse.getCode());
        for (Header header : httpResponse.getHeaders()) {
            responseLine.append("\n# ").append(header.getName()).append(": ").append(header.getValue());
        }
        responseLine.append("\n#");
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(entity);
            }
            httpResponse.setEntity(entity);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    responseLine.append("\n# ").append(line);
                }
            }
        }
        return responseLine.toString();
    }

    private static String getUri(String requestLine) {
        if (requestLine.charAt(0) != '/') {
            return "/" + requestLine;
        }
        return requestLine;
    }
}

