/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TranslogRetention
implements JsonpSerializable {
    @Nullable
    private final String size;
    @Nullable
    private final Time age;
    public static final JsonpDeserializer<TranslogRetention> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslogRetention::setupTranslogRetentionDeserializer);

    private TranslogRetention(Builder builder) {
        this.size = builder.size;
        this.age = builder.age;
    }

    public static TranslogRetention of(Function<Builder, ObjectBuilder<TranslogRetention>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    @Nullable
    public final Time age() {
        return this.age;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (this.age != null) {
            generator.writeKey("age");
            this.age.serialize(generator, mapper);
        }
    }

    protected static void setupTranslogRetentionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::age, Time._DESERIALIZER, "age");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TranslogRetention> {
        @Nullable
        private String size;
        @Nullable
        private Time age;

        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public final Builder age(@Nullable Time value) {
            this.age = value;
            return this;
        }

        public final Builder age(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.age(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TranslogRetention build() {
            this._checkSingleUse();
            return new TranslogRetention(this);
        }
    }
}

