/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.msearch;

import co.elastic.clients.elasticsearch.core.msearch.MultisearchBody;
import co.elastic.clients.elasticsearch.core.msearch.MultisearchHeader;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;

public class RequestItem
implements NdJsonpSerializable,
JsonpSerializable {
    private final MultisearchHeader header;
    private final MultisearchBody body;

    private RequestItem(Builder builder) {
        this.header = ApiTypeHelper.requireNonNull(builder.header, this, "header");
        this.body = ApiTypeHelper.requireNonNull(builder.body, this, "body");
    }

    public static RequestItem of(Function<Builder, ObjectBuilder<RequestItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Iterator<?> _serializables() {
        return Arrays.asList(this.header, this.body).iterator();
    }

    public final MultisearchHeader header() {
        return this.header;
    }

    public final MultisearchBody body() {
        return this.body;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("header");
        this.header.serialize(generator, mapper);
        generator.writeKey("body");
        this.body.serialize(generator, mapper);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RequestItem> {
        private MultisearchHeader header;
        private MultisearchBody body;

        public final Builder header(MultisearchHeader value) {
            this.header = value;
            return this;
        }

        public final Builder header(Function<MultisearchHeader.Builder, ObjectBuilder<MultisearchHeader>> fn) {
            return this.header(fn.apply(new MultisearchHeader.Builder()).build());
        }

        public final Builder body(MultisearchBody value) {
            this.body = value;
            return this;
        }

        public final Builder body(Function<MultisearchBody.Builder, ObjectBuilder<MultisearchBody>> fn) {
            return this.body(fn.apply(new MultisearchBody.Builder()).build());
        }

        @Override
        public RequestItem build() {
            this._checkSingleUse();
            return new RequestItem(this);
        }
    }
}

