/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.ComponentTemplateSummary;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ComponentTemplateNode
implements JsonpSerializable {
    private final ComponentTemplateSummary template;
    @Nullable
    private final Long version;
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<ComponentTemplateNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ComponentTemplateNode::setupComponentTemplateNodeDeserializer);

    private ComponentTemplateNode(Builder builder) {
        this.template = ApiTypeHelper.requireNonNull(builder.template, this, "template");
        this.version = builder.version;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
    }

    public static ComponentTemplateNode of(Function<Builder, ObjectBuilder<ComponentTemplateNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ComponentTemplateSummary template() {
        return this.template;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("template");
        this.template.serialize(generator, mapper);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupComponentTemplateNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::template, ComponentTemplateSummary._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ComponentTemplateNode> {
        private ComponentTemplateSummary template;
        @Nullable
        private Long version;
        @Nullable
        private Map<String, JsonData> meta;

        public final Builder template(ComponentTemplateSummary value) {
            this.template = value;
            return this;
        }

        public final Builder template(Function<ComponentTemplateSummary.Builder, ObjectBuilder<ComponentTemplateSummary>> fn) {
            return this.template(fn.apply(new ComponentTemplateSummary.Builder()).build());
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ComponentTemplateNode build() {
            this._checkSingleUse();
            return new ComponentTemplateNode(this);
        }
    }
}

