/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.dispatch;

import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import org.springframework.util.Assert;

public abstract class TaskReceiver
implements AutoCloseable {
    private final TimingWheel<ExecuteParam> timingWheel;

    public TaskReceiver(TimingWheel<ExecuteParam> timingWheel) {
        Assert.notNull(timingWheel, (String)"Timing wheel cannot null.");
        this.timingWheel = timingWheel;
    }

    public boolean receive(ExecuteParam executeParam) {
        return executeParam != null && this.timingWheel.offer((TimingWheel.Timing)executeParam);
    }

    public void start() {
    }

    @Override
    public void close() {
    }

    public final TimingWheel<ExecuteParam> getTimingWheel() {
        return this.timingWheel;
    }
}

