/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.net.SyslogAppenderBase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SyslogStartConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timesmapStr = null;
    SimpleDateFormat simpleFormat;
    String localHostName;
    int facility;

    public void start() {
        int errorCount = 0;
        String facilityStr = this.getFirstOption();
        if (facilityStr == null) {
            this.addError("was expecting a facility string as an option");
            return;
        }
        this.facility = SyslogAppenderBase.facilityStringToint((String)facilityStr);
        this.localHostName = this.getLocalHostname();
        try {
            this.simpleFormat = new SimpleDateFormat("MMM dd hh:mm:ss", new DateFormatSymbols(Locale.US));
        }
        catch (IllegalArgumentException e) {
            this.addError("Could not instantiate SimpleDateFormat", e);
            ++errorCount;
        }
        if (errorCount == 0) {
            super.start();
        }
    }

    public String convert(LoggingEvent event) {
        StringBuilder sb = new StringBuilder();
        int pri = this.facility + LevelToSyslogSeverity.convert(event);
        sb.append("<");
        sb.append(pri);
        sb.append(">");
        this.fillInTimestamp(sb, event.getTimeStamp());
        sb.append(' ');
        sb.append(this.localHostName);
        sb.append(' ');
        return sb.toString();
    }

    public String getLocalHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            this.addError("Could not determine local host name", uhe);
            return "UNKNOWN_LOCALHOST";
        }
    }

    void fillInTimestamp(StringBuilder sb, long timestamp) {
        if (timestamp != this.lastTimestamp) {
            this.lastTimestamp = timestamp;
            this.timesmapStr = this.simpleFormat.format(new Date(timestamp));
        }
        sb.append(this.timesmapStr);
    }
}

