/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CX;
import ca.uhn.hl7v2.model.v23.datatype.DT;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class DB1
extends AbstractSegment {
    public DB1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - DB1");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(33)}, "Disabled person code");
            this.add(CX.class, false, 0, 32, new Object[]{this.getMessage()}, "Disabled person identifier");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Disabled Indicator");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Disability start date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Disability end date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Disability return to work date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Disability unable to work date");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DB1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDDB1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getDb11_SetIDDB1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getDisabledPersonCode() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getDb12_DisabledPersonCode() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public CX[] getDisabledPersonIdentifier() {
        CX[] retVal = (CX[])this.getTypedField(3, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getDb13_DisabledPersonIdentifier() {
        CX[] retVal = (CX[])this.getTypedField(3, (Type[])new CX[0]);
        return retVal;
    }

    public int getDisabledPersonIdentifierReps() {
        return this.getReps(3);
    }

    public CX getDisabledPersonIdentifier(int rep) {
        CX retVal = (CX)this.getTypedField(3, rep);
        return retVal;
    }

    public CX getDb13_DisabledPersonIdentifier(int rep) {
        CX retVal = (CX)this.getTypedField(3, rep);
        return retVal;
    }

    public int getDb13_DisabledPersonIdentifierReps() {
        return this.getReps(3);
    }

    public CX insertDisabledPersonIdentifier(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX insertDb13_DisabledPersonIdentifier(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX removeDisabledPersonIdentifier(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public CX removeDb13_DisabledPersonIdentifier(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public ID getDisabledIndicator() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getDb14_DisabledIndicator() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public DT getDisabilityStartDate() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public DT getDb15_DisabilityStartDate() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public DT getDisabilityEndDate() {
        DT retVal = (DT)this.getTypedField(6, 0);
        return retVal;
    }

    public DT getDb16_DisabilityEndDate() {
        DT retVal = (DT)this.getTypedField(6, 0);
        return retVal;
    }

    public DT getDisabilityReturnToWorkDate() {
        DT retVal = (DT)this.getTypedField(7, 0);
        return retVal;
    }

    public DT getDb17_DisabilityReturnToWorkDate() {
        DT retVal = (DT)this.getTypedField(7, 0);
        return retVal;
    }

    public DT getDisabilityUnableToWorkDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getDb18_DisabilityUnableToWorkDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(33));
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 4: {
                return new DT(this.getMessage());
            }
            case 5: {
                return new DT(this.getMessage());
            }
            case 6: {
                return new DT(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

