/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ResponseCode {
    HTTP_200_OK(200, "OK"),
    HTTP_400_BAD_REQUEST(400, "Bad Request"),
    HTTP_500_INTERNAL_SERVER_ERROR(500, "Internal Server Error");

    private int myCode;
    private String myMessage;
    private static final Map<AcknowledgmentCode, ResponseCode> ourAckCodesToResponseCodes;
    private static final Logger ourLog;

    static {
        ourAckCodesToResponseCodes = new HashMap<AcknowledgmentCode, ResponseCode>();
        ourLog = LoggerFactory.getLogger(ResponseCode.class);
        ourAckCodesToResponseCodes.put(AcknowledgmentCode.AA, HTTP_200_OK);
        ourAckCodesToResponseCodes.put(AcknowledgmentCode.CA, HTTP_200_OK);
        ourAckCodesToResponseCodes.put(AcknowledgmentCode.AR, HTTP_200_OK);
        ourAckCodesToResponseCodes.put(AcknowledgmentCode.CR, HTTP_200_OK);
        ourAckCodesToResponseCodes.put(AcknowledgmentCode.AE, HTTP_200_OK);
        ourAckCodesToResponseCodes.put(AcknowledgmentCode.CE, HTTP_200_OK);
    }

    private ResponseCode(int theCode, String theMessage) {
        this.myCode = theCode;
        this.myMessage = theMessage;
    }

    public static ResponseCode forAcknowledgementCode(String theAcknowledgementCode) {
        ResponseCode retVal = null;
        if (theAcknowledgementCode != null) {
            retVal = ourAckCodesToResponseCodes.get(AcknowledgmentCode.valueOf((String)theAcknowledgementCode));
        } else {
            ourLog.warn("No HTTP response code defined for acknowledgement code: " + theAcknowledgementCode);
            retVal = HTTP_500_INTERNAL_SERVER_ERROR;
        }
        if (retVal == null) {
            ourLog.warn("No HTTP response code defined for acknowledgement code: " + theAcknowledgementCode);
            retVal = HTTP_500_INTERNAL_SERVER_ERROR;
        }
        return retVal;
    }

    public static ResponseCode detect(String theRawMessage) {
        switch (EncodingStyle.detect(theRawMessage)) {
            default: {
                StringTokenizer tok = new StringTokenizer(theRawMessage, "\r");
                while (tok.hasMoreTokens()) {
                    String nextSegment = tok.nextToken();
                    if (!nextSegment.startsWith("MSA") || nextSegment.length() < 6) continue;
                    String code = nextSegment.substring(4, 6);
                    return ResponseCode.forAcknowledgementCode(code);
                }
                ourLog.warn("Could not detect MSA.1 value in ER7 message");
                return HTTP_500_INTERNAL_SERVER_ERROR;
            }
            case XML: 
        }
        Pattern p = Pattern.compile("<MSA\\.1>(.*?)</MSA\\.1>");
        Matcher m = p.matcher(theRawMessage);
        if (m.find()) {
            String code = m.group(1);
            return ResponseCode.forAcknowledgementCode(code);
        }
        ourLog.warn("Could not detect MSA.1 value in XML message");
        return HTTP_500_INTERNAL_SERVER_ERROR;
    }

    public int getCode() {
        return this.myCode;
    }

    public void setCode(int theCode) {
        this.myCode = theCode;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public void setMessage(String theMessage) {
        this.myMessage = theMessage;
    }
}

